<?php

namespace Modules\Suppliers\Http\Requests;

use App\Http\Requests\Request;

/**
 * Class SuppliersRequest
 * @package Modules\Suppliers\Http\Requests
 */
class SuppliersRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $company_id = $this->request->get('company_id');

        return [
            'company_id' => 'required',
            'fantasy_name' => 'required|unique:suppliers,fantasy_name,NULL,id,company_id,' . $company_id,
            'email' => 'required|unique:suppliers,email' ,
            'person_tax_number-company_tax_number' => 'required|unique:suppliers,person_tax_number-company_tax_numberNULL,id,company_id,' . $company_id,
        ];
    }

    public function attributes() {
        return [
            'name' => trans('companies::companies.form.name'),
            'place_id' => trans('places::places.module'),
            'company_id' => trans('companies::companies.module'),
        ];
    }

}