@extends('layouts.app')

@section('content')
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <!-- END: Subheader -->

        <div class="m-content">

            @include('flash::message')

             <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">

                <div class="m-portlet__head" style="">

                    <div class="m-portlet__head-wrapper">
                        <div class="m-portlet__head-caption">
                            <div class="m-portlet__head-title">

                                <h3 class="m-portlet__head-text">
                                    @lang('reports::reports.module')
                                    <small>@lang('reports::reports.module_description')</small>
                                </h3>

                            </div>
                        </div>

                    </div>
                </div>

                <div class="m-content">
                    <div class="m-portlet__body">

                        @if( !\Auth::user()->hasRole('gerente') )

                            <div class="row">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mx-auto">

                                    {!! form($form) !!}

                                </div>
                            </div>

                        @endif

                        <div class="row">
                            <div class="col-xl-6 col-12 mx-auto">

                                @include("reports::charts.costs_pie_chart")

                            </div>

                            <div class="col-xl-6 col-12 mx-auto">

                                @include("reports::charts.costs_container_chart")
                                
                            </div>

                        </div>

                        <div class="row">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mx-auto">

                                <a href="{!! $reportLink !!}" class="btn btn-primary waves-effect pull-right" style="display: inline-block">@lang('reports::reports.print')</a>

                            </div>
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12 mx-auto">

                                {!! $dataTable->table(['width' => '100%']) !!}

                            </div>
                        </div>
    

                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@push('scripts')

    <script src="{!! Module::asset('reports:js/BAP_CostReports.js') !!}"></script>

@endpush


@push('scripts')
    {!! $dataTable->scripts() !!}
@endpush

