<?php

namespace Modules\Reports\Http\Controllers;

use PDF;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Category;
use Modules\Asset\Service\AssetService;
use Modules\Companies\Entities\Company;
use Modules\Reports\Http\Forms\ReportForm;
use Kris\LaravelFormBuilder\FormBuilderTrait;
use Modules\Reports\Datatables\CostsReportDatatable;
use Modules\Platform\Core\Datatable\Scope\OwnableEntityScope;
use Modules\Platform\Core\Http\Controllers\AppBaseController;

class CostsReportController extends AppBaseController
{
    use FormBuilderTrait;

    protected $datatable = CostsReportDatatable::class;

    protected $formClass = ReportForm::class;

    /**
     * Reports
     * @return \Illuminate\View\View
     */
    public function index(Request $request) {

        $data = $request->all();

        $assetService = \App::make(AssetService::class);
        $datatable = \App::make($this->datatable);

        $datatable->setTableId('RelatedModalTable');

        $dataPieChartCategory = '';

        if($request->exists('place') && $request->exists('company')){
            $request->session()->put('placeReport',$data['place']);
            $request->session()->put('companyReport',$data['company']);
        }

        if($request->exists('company') && $request->get('company') != null){

            if($request->exists('place') && $request->get('place') != ''){

                $datatable->setQueryType(CostsReportDatatable::QUERY_BY_PLACE);
                $datatable->setIdQuery($request->get('place'));
                $totalCost = $assetService->getTotalCost(null,$request->get('place'));
                $dataPieChart = $assetService->getByCategoryCosts(null,$request->get('place'));
                $dataBarChart = $assetService->getCosts($request->session()->get('companyReport'),$request->session()->get('placeReport'));
                $reportLink = route('costs.reports.pdfplacereport',[$request->session()->get('companyReport'),$request->session()->get('placeReport')]);
            }
            else {

                $datatable->setQueryType(CostsReportDatatable::QUERY_BY_COMPANY);
                $datatable->setIdQuery($request->get('company'));
                $totalCost = $assetService->getTotalCost($request->get('company'));
                $dataPieChart = $assetService->getByCategoryCosts($request->get('company'));
                $dataBarChart = $assetService->getCosts($request->session()->get('companyReport'));
                $reportLink = route('costs.reports.pdfcompanyreport', $request->get('company'));
            }
        }

        else {

            if(\Auth::user()->hasRole('admin')){

                $datatable->setQueryType(CostsReportDatatable::GENERAL_QUERY);
                $totalCost = $assetService->getTotalCost();
                $dataPieChart = $assetService->getByCategoryCosts();
                $dataBarChart = $assetService->getCosts();
                $reportLink = route('costs.reports.pdfreport');
            }
            elseif(\Auth::user()->hasRole('chefe')){

                $datatable->setQueryType(CostsReportDatatable::QUERY_BY_COMPANY);
                $datatable->setIdQuery(\Auth::user()->company_id);
                $totalCost = $assetService->getTotalCost(\Auth::user()->company_id);
                $dataPieChart = $assetService->getByCategoryCosts(\Auth::user()->company_id);
                $dataBarChart = $assetService->getCosts(\Auth::user()->company_id);
                $reportLink = route('costs.reports.pdfcompanyreport', \Auth::user()->company_id);
            }
            elseif(\Auth::user()->hasRole('gerente')){

                $datatable->setQueryType(CostsReportDatatable::QUERY_BY_PLACE);
                $datatable->setIdQuery(\Auth::user()->place_id);
                $totalCost = $assetService->getTotalCost(null,\Auth::user()->place_id);
                $dataPieChart = $assetService->getByCategoryCosts(null,\Auth::user()->place_id);
                $dataBarChart = $assetService->getCosts(\Auth::user()->company_id, \Auth::user()->place_id);
                $reportLink = route('costs.reports.pdfplacereport',[\Auth::user()->company_id, \Auth::user()->place_id]);
            }

        }

        if(isset($data['draw'])){

            if($request->session()->exists('companyReport') && $request->session()->get('companyReport') != ''){

                if($request->session()->exists('placeReport') && $request->session()->get('placeReport') != ''){

                    $datatable->setQueryType(CostsReportDatatable::QUERY_BY_PLACE);
                    $datatable->setIdQuery($request->session()->get('placeReport'));
                    $totalCost = $assetService->getTotalCost(null,$request->session()->get('placeReport'));
                    $dataPieChart = $assetService->getByCategoryCosts($request->session()->get('placeReport'));
                    $dataBarChart = $assetService->getCosts($request->session()->get('companyReport'),$request->session()->get('placeReport'));
                    $reportLink = route('costs.reports.pdfplacereport',[$request->session()->get('companyReport'),$request->session()->get('placeReport')]);
                }
                else {

                    $datatable->setQueryType(CostsReportDatatable::QUERY_BY_COMPANY);
                    $datatable->setIdQuery($request->session()->get('companyReport'));
                    $totalCost = $assetService->getTotalCost($request->session()->get('companyReport'));
                    $dataPieChart = $assetService->getByCategoryCosts($request->session()->get('companyReport'));
                    $dataBarChart = $assetService->getCosts($request->session()->get('companyReport'));
                    $reportLink = route('costs.reports.pdfcompanyreport', $request->session()->get('companyReport'));
                }
            }
            else{

                if(\Auth::user()->hasRole('admin')){

                    $datatable->setQueryType(CostsReportDatatable::GENERAL_QUERY);
                    $totalCost = $assetService->getTotalCost();
                    $dataPieChart = $assetService->getByCategoryCosts();
                    $dataBarChart = $assetService->getCosts();
                    $reportLink = route('costs.reports.pdfreport');
                }
                elseif(\Auth::user()->hasRole('chefe')){

                    $datatable->setQueryType(CostsReportDatatable::QUERY_BY_COMPANY);
                    $datatable->setIdQuery(\Auth::user()->company_id);
                    $totalCost = $assetService->getTotalCost(\Auth::user()->company_id);
                    $dataPieChart = $assetService->getByCategoryCosts(\Auth::user()->company_id);
                    $dataBarChart = $assetService->getCosts(\Auth::user()->company_id);
                    $reportLink = route('costs.reports.pdfcompanyreport', \Auth::user()->company_id);
                }
                elseif(\Auth::user()->hasRole('gerente')){

                    $datatable->setQueryType(CostsReportDatatable::QUERY_BY_PLACE);
                    $datatable->setIdQuery(\Auth::user()->place_id);
                    $totalCost = $assetService->getTotalCost(null,\Auth::user()->place_id);
                    $dataPieChart = $assetService->getByCategoryCosts(null,\Auth::user()->place_id);
                    $dataBarChart = $assetService->getCosts(\Auth::user()->company_id, \Auth::user()->place_id);
                    $reportLink = route('costs.reports.pdfplacereport',[\Auth::user()->company_id, \Auth::user()->place_id]);
                }
            }

            $request->session()->forget('placeReport');
            $request->session()->forget('companyReport');

        }

        $form = $this->form($this->formClass, [
            'method' => 'GET',
            'url' => '/reports/costs',
            'id' => 'module_form',
            'model' => $data
        ]);

        $datatable->setAjaxSource(route('costs.reports'));
        $datatable->addScope(new OwnableEntityScope(\Auth::user(), 'reports'));

        $categories = Category::all();

        \JavaScript::put([
            'dataPieChart' => json_encode($dataPieChart),
            'dataBarChart' => json_encode($dataBarChart),
            'categories' => json_encode($categories),
        ]);

        return $datatable = $datatable->render('reports::costs',
            compact(
                'totalCost',
                'dataPieChart',
                'dataContainerChart',
                'form',
                'reportLink',
                'categories',
                'dataPieChartCategory'
            )
        );

    }

    public function pdfReport($company_id = null,$place_id = null){

        if($place_id != null){
            $categories = Category::where('company_id', Place::find($place_id)->company_id)->get()->toArray();
        }
        elseif($company_id != null){
            $categories = Category::where('company_id', $company_id)->get()->toArray();
        }
        else{
            $categories = Category::all();
        }

        $assetService = \App::make(AssetService::class);

        foreach($categories as &$category){
            if($place_id != null){
                $category['current_value'] = $assetService->getCurrentValueByCategory($category,null,$place_id);
                $category['assets_quantity'] = Asset::where([
                    ['category_id', $category['id']],
                    ['place_id', $place_id]
                ])->count();
                $category['average_cost'] = $assetService->getAverageCostByCategory($category,null,$place_id);
                $category['purchase_value'] = $assetService->getPurchaseValueByCategory($category,null,$place_id);
            }
            elseif($company_id != null){
                $category['current_value'] = $assetService->getCurrentValueByCategory($category,$company_id);
                $category['assets_quantity'] = Asset::where([
                    ['category_id', $category['id']],
                    ['company_id', $company_id]
                ])->count();
                $category['average_cost'] = $assetService->getAverageCostByCategory($category,$company_id);
                $category['purchase_value'] = $assetService->getPurchaseValueByCategory($category,$company_id);
            }
            else{
                $category['current_value'] = $assetService->getCurrentValueByCategory($category);
                $category['assets_quantity'] = Asset::where('category_id', $category['id'])->count();
                $category['average_cost'] = $assetService->getAverageCostByCategory($category);
                $category['purchase_value'] = $assetService->getPurchaseValueByCategory($category);
            }
        }

        if($place_id != null){
            $place = Place::find($place_id);
            $fileName = trans('reports::reports.asset_costs_report') . $place->identifier_name . '.pdf';
            $view = view('reports::reports.pdfReportCosts', [
                'categories' => $categories,
                'place' => $place
            ]);
        }
        elseif($company_id != null){
            $company = Company::find($company_id);
            $fileName = trans('reports::reports.asset_costs_report') . $company->name . '.pdf';
            $view = view('reports::reports.pdfReportCosts', [
                'categories' => $categories,
                'company' => $company
            ]);
        }
        else{
            $fileName = trans('reports::reports.asset_costs_report') . '.pdf';
            $view = view('reports::reports.pdfReportCosts', [
                'categories' => $categories
            ]);
        }

        $pdf = PDF::loadHTML($view);

        return $pdf->download($fileName);

    }


}
