<?php

namespace Modules\Reports\Datatables;

use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Category;
use Modules\Asset\Service\AssetService;
use Modules\Companies\Entities\Company;
use Yajra\DataTables\EloquentDataTable;
use Modules\Collaborators\Entities\Area;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Platform\Core\Helper\DataTableHelper;
use Modules\Platform\Core\Datatable\PlatformDataTable; 

class CostsReportDatatable extends PlatformDataTable {
 

    const QUERY_BY_PLACE   = 1;
    const QUERY_BY_COMPANY = 2;
    const GENERAL_QUERY    = 3;

    const SHOW_URL_ROUTE = '';
    const EDIT_URL_ROUTE = '';
    const REMOVE_URL_ROUTE = '';

    protected $idQuery;
    protected $queryType;

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE);

        return $dataTable;
    }

    /**
     * Get query source of dataTable.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Asset $model)
    {

        $query = $model->newQuery()
        ->leftJoin('categories', 'assets.category_id', '=', 'categories.id')
        ->selectRaw('count(categories.id) as assets_quantity, categories.id, categories.name')
        ->groupBy('categories.id')
        ->groupBy('categories.name');

        if($this->queryType == $this::QUERY_BY_PLACE){
            $query = $query->where('assets.place_id',$this->idQuery);
        }
        if($this->queryType == $this::QUERY_BY_COMPANY){
            $query = $query->where('assets.company_id',$this->idQuery);
        }

        // $query = $query->groupBy('category_id');

        return $query;
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        $currentColumn = 0;
        $columnFilters = [];

        // $columnFilters[] = [
        //     'column_number' => $currentColumn++,
        //     'filter_type' => 'text'
        // ];

        // $data_areas = [];
        // if($this->queryType == $this::QUERY_BY_PLACE){

        //     $areas = Area::where('company_id', Place::find($this->idQuery)->company_id)->get()->toArray();
        // }
        // if($this->queryType == $this::QUERY_BY_COMPANY){

        //     $areas = Area::where('company_id', $this->idQuery)->get()->toArray();
        // }
        // if($this->queryType == $this::GENERAL_QUERY){

        //     $areas = Area::all()->toArray();
        // }

        // foreach ($areas as $area){
        //     $data_areas[] = [
        //         'value' => $area['id'],
        //         'label' => $area['name'],
        //     ];
        // }

        // $columnFilters[] = [
        //     'column_number' => $currentColumn++,
        //     'filter_type' => 'select',
        //     'select_type' => 'select2',
        //     'select_type_options' => [
        //         'theme' => "bootstrap",
        //         'width' => '100%'
        //     ],
        //     'data' => $data_areas                    
        // ];

        // $data_categories = [];

        // if($this->queryType == $this::QUERY_BY_PLACE){

        //     $categories = Category::where('company_id', Place::find($this->idQuery)->company_id)->get()->toArray();
        // }
        // if($this->queryType == $this::QUERY_BY_COMPANY){

        //     $categories = Category::where('company_id', $this->idQuery)->get()->toArray();
        // }
        // if($this->queryType == $this::GENERAL_QUERY){

        //     $categories = Category::all()->toArray();
        // }

        // foreach ($categories as $category){
        //     $data_categories[] = [
        //         'value' => $category['id'],
        //         'label' => $category['name'],
        //     ];
        // }

        // $columnFilters[] = [
        //     'column_number' => $currentColumn++,
        //     'filter_type' => 'select',
        //     'select_type' => 'select2',
        //     'select_type_options' => [
        //         'theme' => "bootstrap",
        //         'width' => '100%'
        //     ],
        //     'data' => $data_categories
        // ];

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text',
        ];


        return $this->builder()
            ->columns($this->getColumns())
            ->setTableAttribute('class', 'table responsive table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
                'stateSave' => true,
                'columnFilters' => $columnFilters,
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true,
            ]);
    }

    /**
     * @return array
     */
    protected function getColumns() {

        $data = [];

        $data += [
            'name' => [
                'name' => 'name',
                'data' => 'name',
                'title' => trans('reports::reports.table.category_name'),
                'data_type' => 'text'
            ],
            'assets_quantity' => [
                'name' => 'assets_quantity',
                'data' => 'assets_quantity',
                'title' => trans('reports::reports.table.itens_quantity'),
                'data_type' => 'text'
            ],
            'average_cost' => [
                'data' => 'average_cost',
                'title' => trans('reports::reports.table.average_cost'),
                'data_type' => 'text'
            ],
            'purchase_value' => [
                'data' => 'purchase_value',
                'title' => trans('reports::reports.table.purchase_value'),
                'data_type' => 'text'
            ],
            'current_value' => [
                'data' => 'current_value',
                'title' => trans('reports::reports.table.current_value'),
                'data_type' => 'text'
            ],
        ];

        return $data;

    }


    /**
     * Overwritten function for edit some columns
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function ajax()
    {
        $source = null;
        if (method_exists($this, 'query')) {
            $source = app()->call([$this, 'query']);
            $source = $this->applyScopes($source);
        }

        /** @var \Yajra\DataTables\DataTableAbstract $dataTable */
        $dataTable = app()->call([$this, 'dataTable'], compact('source'));

        if ($callback = $this->beforeCallback) {
            $callback($dataTable);
        }

        if ($callback = $this->responseCallback) {
            $data = new Collection($dataTable->toArray());

            return new JsonResponse($callback($data));
        }

        $assetService = \App::make(AssetService::class);
        $queryType = $this->queryType;
        $idQuery = $this->idQuery;

        $dataTable->editColumn('current_value', function ($category) use ($assetService,$queryType,$idQuery) {

            if($queryType == '1'){
                return $assetService->getCurrentValueByCategory($category,null,$idQuery);
            }
            elseif($queryType == '2'){
                return $assetService->getCurrentValueByCategory($category,$idQuery);
            }
            else{
                return $assetService->getCurrentValueByCategory($category);
            }

        });

        $dataTable->editColumn('purchase_value', function ($category) use ($assetService,$queryType,$idQuery) {

            if($queryType == '1'){
                return $assetService->getPurchaseValueByCategory($category,null,$idQuery);
            }
            elseif($queryType == '2'){
                return $assetService->getPurchaseValueByCategory($category,$idQuery);
            }
            else{
                return $assetService->getPurchaseValueByCategory($category);
            }

        });
        $dataTable->editColumn('average_cost', function ($category) use ($assetService,$queryType,$idQuery) {

            if($queryType == '1'){
                return $assetService->getAverageCostByCategory($category,null,$idQuery);
            }
            elseif($queryType == '2'){
                return $assetService->getAverageCostByCategory($category,$idQuery);
            }
            else{
                return $assetService->getAverageCostByCategory($category);
            }
        });

        return $dataTable->toJson();
    }


    public function setIdQuery($id){
        $this->idQuery = $id;
    }

    public function setQueryType($type){
        $this->queryType = $type;
    }

}
