<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddUserInformation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::table('users', function (Blueprint $table) {
            $table->integer('company_id')->unsigned()->nullable();
            $table->foreign('company_id')->references('id')->on('companies');

            $table->string('person_tax_number')->nullable();

            $table->string('personal_id')->nullable();

            $table->string('company_tax_number')->nullable();

            $table->date('birthday')->nullable();

            $table->string('number')->nullable();

            $table->string('neighborhood')->nullable();

            $table->string('complement')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {

            $table->dropColumn('company_id');

            $table->dropColumn('person_tax_number');

            $table->dropColumn('personal_id');

            $table->dropColumn('company_tax_number');

            $table->dropColumn('birthday');

            $table->dropColumn('number');

            $table->dropColumn('neighborhood');

            $table->dropColumn('complement');

        });
    }
}
