@extends('layouts.app')

@section('content')
    @include('settings::partial.menu')
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <div class="m-subheader ">
            <div class="d-flex align-items-center">
                <div class="mr-auto">
                    <h3 class="m-subheader__title m-subheader__title--separator">

                        @lang('settings::outgoing_server.module')
                        <small>@lang('settings::outgoing_server.module_description')</small>

                    </h3>
                </div>
            </div>
        </div>
        <!-- END: Subheader -->                      

        <div class="m-content">

            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile m-portlet--sticky">
                <div class="m-portlet__body">
                    
                    {!! form($outgoing_server_form) !!}

                    <div class="m-separator m-separator--dashed m-separator--lg"></div>
                    
                    <div class="m-form__heading">
                        <h3 class="m-form__heading-title">

                            @lang('settings::outgoing_server.send_test_email')
                        </h3>
                    </div>

                    {!! form($test_email_form)  !!}
                </div>
            </div>

        </div>
    </div>
@endsection


@push('scripts')
    {!! JsValidator::formRequest(\Modules\Platform\Settings\Http\Requests\SaveOutgoingServerRequest::class, '#outgoing_server_form') !!}
    {!! JsValidator::formRequest(\Modules\Platform\Settings\Http\Requests\OutgoingServerTestMailRequest::class, '#outgoing_server_test_email_form') !!}
@endpush
