
@extends('layouts.app')

@section('content')
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <!-- END: Subheader -->                      

        <div class="m-content">
            
            @include('flash::message')

             <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">

                <div class="m-portlet__head" style="">
                    <div class="m-portlet__head-progress">

                        <!-- here can place a progress bar-->
                    </div>
                    
                    <div class="m-portlet__head-wrapper">
                        <div class="m-portlet__head-caption">
                            <div class="m-portlet__head-title">

                                <span class="m-portlet__head-icon">
                                    <i class="@lang($language_file . '.entity_icon')"></i>
                                </span>

                                <h3 class="m-portlet__head-text">
                                    @lang($language_file.'.module')
                                    <small>@lang($language_file.'.module_description')</small>
                                </h3>

                            </div>
                        </div>

                        <div class="m-portlet__head-tools">
                            @if($settingsBackRoute != '')
                                <a href="{{ route($settingsBackRoute) }}" class="btn btn-secondary m-btn--icon m--margin-right-10" title="@lang('core::core.crud.back')">
                                    <span>
                                        <i class="la la-arrow-left"></i>
                                        <span>@lang('core::core.crud.back')</span>
                                    </span>
                                </a>
                            @endif

                            @if($permissions['create'] == '' or Auth::user()->hasPermissionTo($permissions['create']))
                                <a href="{{ route($routes['create']) }}" class="btn btn-brand m--margin-right-10 m-btn m-btn--icon m-btn--wide m-btn--md btn-create btn-crud">@lang('core::core.crud.create')</a>
                            @endif

                            @if($settingsPermission != '' && Auth::user()->hasPermissionTo($settingsPermission))
                                @if(count($moduleSettingsLinks) > 0 )

                                <div class="dropdown">
                                    <button class="btn m-btn--md btn-info dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                         @lang('core::core.settings')
                                    </button>

                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" x-placement="bottom-start">
                                        @foreach($moduleSettingsLinks as $link)
                                             <a class="dropdown-item" href="{{ route($link['route']) }}">{{ trans($language_file.'.'.$link['label']) }}</a>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                            @endif
                        </div>

                        

                    </div>
                </div>

                <div class="m-portlet__body">
                        {!! $dataTable->table(['width' => '100%']) !!}
                </div>
            </div>
        </div>
    </div>

@endsection


@push('scripts')
    @foreach($jsFiles as $jsFile)
        <script src="{!! Module::asset($moduleName.':js/'.$jsFile) !!}"></script>
    @endforeach
@endpush

@push('scripts')
    {!! $dataTable->scripts() !!}
@endpush


