
@extends('layouts.app')

@section('content')
    
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <div class="m-subheader ">
            <div class="d-flex align-items-center">
                <div class="mr-auto">

                </div>
            </div>
        </div>
        <!-- END: Subheader -->                      

        <div class="m-content">
             <div class="m-portlet m-portlet--mobile">

                <div class="m-portlet__head" style="">
                    <div class="m-portlet__head-progress">

                        <!-- here can place a progress bar-->
                    </div>
                    
                    <div class="m-portlet__head-wrapper">
                        <div class="m-portlet__head-caption">
                            <div class="m-portlet__head-title">
                                <span class="m-portlet__head-icon">
                                    <i class="@lang($language_file . '.entity_icon')"></i>
                                </span>

                                <h3 class="m-portlet__head-text">
                                    @lang($language_file.'.module')  - @lang('core::core.crud.edit')
                                <small>@lang($language_file.'.module_description')</small>
                                </h3>

                            </div>
                        </div>

                        <div class="m-portlet__head-tools">
                            <a href="{{ route($routes['show'],$entity) }}" class="btn btn-secondary m-btn--icon m--margin-right-10" title="@lang('core::core.crud.back')">
                                <span>
                                    <i class="la la-arrow-left"></i>
                                    <span>@lang('core::core.crud.back')</span>
                                </span>
                            </a>

                        </div>

                    </div>
                </div>

                <div class="m-portlet__body">
                    {!! form_start($form) !!}

                    @foreach($show_fields as $panelName => $panel)

                        {{ Html::section($language_file,$panelName) }}


                        @foreach($panel as $fieldName => $options)

                            @if(!isset($options['hide_in_form']))
                                @if($loop->iteration % 2 == 0)
                                    <div class="{{ isset($options['col-class']) ? $options['col-class'] : 'col-lg-12 col-md-12 col-sm-12' }}">
                                        @else
                                            <div class="{{ isset($options['col-class']) ? $options['col-class'] : 'col-lg-12 col-md-12 col-sm-12 clear-left' }}">
                                                @endif

                                                {!! form_row($form->{$fieldName}) !!}
                                            </div>
                                        @endif

                        @endforeach

                    @endforeach
                    {!! form_end($form, $renderRest = true) !!}
                                    </div>

                </div>
            </div>
        </div>
    </div>

    @foreach($includeViews as $v)
        @include($v)
    @endforeach

@endsection


@push('css')
    @foreach($cssFiles as $file)
        <link rel="stylesheet" href="{!! Module::asset($moduleName.':css/'.$file) !!}"></link>
    @endforeach
@endpush

@push('scripts')
    @foreach($jsFiles as $jsFile)
                <script src="{!! Module::asset($moduleName.':js/'.$jsFile) !!}"></script>
    @endforeach
@endpush



@if($form_request != null )
    @push('scripts')
        {!! JsValidator::formRequest($form_request, '#module_form') !!}
    @endpush
@endif
