<?php

namespace Modules\Platform\Core\Datatable\Scope;

use Modules\Platform\Core\Interfaces\CrudRelatedScope;
use Yajra\DataTables\Contracts\DataTableScope;

/**
 * Class BasicRelationScope
 * @package Modules\Platform\Core\Datatable\Scope
 */
class BasicRelationScope implements DataTableScope, CrudRelatedScope
{
    private $relation;
    private $prefix;

	public function prefix($prefix)
    {
        $this->prefix = $prefix;
    }    

    public function relation($relation)
    {
        $this->relation = $relation;
    }

    public function apply($query)
    {
    	if ($this->prefix) {
	        $query->whereIn($this->prefix . '.id', $this->relation->pluck('id')->toArray());

    	} else {
	        $query->whereIn('id', $this->relation->pluck('id')->toArray());
    	}
    }
}
