@extends('layouts.app')

@section('content')
    
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <div class="m-subheader ">
            <div class="d-flex align-items-center">
                <div class="mr-auto">

                </div>
            </div>
        </div>
        <!-- END: Subheader -->                      

        <div class="m-content">
            @include('flash::message')
            
             <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">

                <div class="m-portlet__head" style="">
                    <div class="m-portlet__head-progress">

                        <!-- here can place a progress bar-->
                    </div>
                    
                    <div class="m-portlet__head-wrapper">
                        <div class="m-portlet__head-caption">
                            <div class="m-portlet__head-title">
                                <span class="m-portlet__head-icon">
                                    <i class="@lang($language_file . '.entity_icon')"></i>
                                </span>

                                <h3 class="m-portlet__head-text">
                                    @lang($language_file.'.module') - @lang('core::core.crud.show')
                                    <small>@lang($language_file.'.module_description')</small>
                                </h3>

                            </div>
                        </div>

                        <div class="m-portlet__head-tools">
                            <a href="{{ route($routes['index']) }}" class="btn btn-secondary m-btn--icon m--margin-right-10" title="@lang('core::core.crud.back')">
                                <span>
                                    <i class="la la-arrow-left"></i>
                                    <span>@lang('core::core.crud.back')</span>
                                </span>
                            </a>
                             <div class="btn-group next-prev-btn-group m--margin-right-10" role="group">
                                @if($prev_record)
                                    <a href="{{ route($routes['show'],$prev_record) }}"
                                       title="@lang('core::core.crud.prev')"
                                       class="btn btn-metal m-btn m-btn--icon btn-crud btn-prev">@lang('core::core.crud.prev')</a>
                                @endif

                                @if($next_record)
                                    <a href="{{ route($routes['show'],$next_record) }}"
                                       title="@lang('core::core.crud.next')"
                                       class="btn btn-metal m-btn m-btn--icon btn-crud btn-next">@lang('core::core.crud.next')</a>
                                @endif
                            </div>
                            
                            @if($permissions['destroy'] == '' or Auth::user()->hasPermissionTo($permissions['destroy']))

                            {!! Form::open(['route' => [$routes['destroy'], $entity], 'method' => 'delete']) !!}

                            {!! Form::button(trans('core::core.crud.delete'), [ 'type' => 'submit', 'class' => 'btn m--margin-right-10 btn-outline-danger btn-edit btn-crud', 'onclick' => "return confirm($.i18n._('are_you_sure'))" ]) !!}

                            {!! Form::close() !!}
                            @endif

                            @if($permissions['update'] == '' or Auth::user()->hasPermissionTo($permissions['update']))
                            <div class="btn-group">
                                <a href="{{ route($routes['edit'],$entity) }}"
                               class="btn btn-brand  m-btn btn-edit btn-crud">
                                    @lang($language_file.'.edit')
                                </a>

                                @if(isset($customShowButtons) && count($customShowButtons) > 0)
                                    <button type="button" class="btn btn-brand  dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right">

                                        @foreach($actionButtons as $link)
                                           <a class="dropdown-item" 
                                                href="{{ isset($link['href']) ? $link['href'] : '#' }}"
                                                @foreach($link['attr'] as $key => $value)
                                                    {{$key}}="{{$value}}"
                                                @endforeach
                                                >
                                                {{ $link['label'] }}
                                            </a>
                                        @endforeach

                                        @foreach($customShowButtons as $btn)
                                        <a class="dropdown-item" 
                                            href="{{ isset($btn['href']) ? $btn['href'] : '#' }}"
                                            @foreach($btn['attr'] as $key => $value)
                                                {{$key}}="{{$value}}"
                                            @endforeach
                                            >
                                            {{ $btn['label'] }}
                                        </a>
                                        @endforeach
                                    
                                    </div>
                                @endif
                            </div>
                            @endif
                        </div>

                    </div>
                </div>

                <div class="m-portlet__body">
                    

                @if($show_fileds_count > 1 || $hasExtensions)

                    <ul class="nav nav-tabs  m-tabs-line m-tabs-line--primary" role="tablist">
                        
                        <li class="nav-item m-tabs__item active">
                            <a class="nav-link m-tabs__link active" href="#tab_details" data-toggle="tab"
                               title="@lang('core::core.tabs.details')">
                                @isset($baseIcons,'details_label')
                                    @lang('core::core.tabs.details')
                                @endisset
                            </a>
                        </li>

                        <li class="nav-item m-tabs__item">
                            <a id="dashboard_tab" class="nav-link m-tabs__link" href="#tab_dashboard" data-toggle="tab" title="@lang('companies::companies.dashboard')">
                                @lang('companies::companies.dashboard')
                            </a>
                        </li>

                         @foreach($relationTabs as $tabKey => $tab)
                            @if(Auth::user()->hasPermissionTo($tab['permissions']['browse']))
                                <li class="nav-item m-tabs__item">
                                    <a class="nav-link m-tabs__link" href="#tab_{{$tabKey}}" data-toggle="tab" title="@lang($language_file.'.tabs.'.$tabKey)">
                                        @lang($language_file.'.tabs.'.$tabKey)
                                    </a>
                                </li>
                            @endif
                        @endforeach

                        @if($commentableExtension)
                            <li class="nav-item m-tabs__item">
                                <a class="nav-link m-tabs__link" href="#tab_comments" data-toggle="tab"
                                   title="@lang('core::core.tabs.comments')">
                                    @isset($baseIcons,'comments_label')
                                        @lang('core::core.tabs.comments')
                                    @endisset
                                </a>
                            </li>
                        @endif

                        @if($attachmentsExtension)
                            <li class="nav-item m-tabs__item">
                                <a class="nav-link m-tabs__link" href="#tab_attachments" data-toggle="tab"
                                   title="@lang('core::core.tabs.attachments')">
                                    @isset($baseIcons,'attachments_label')
                                        @lang('core::core.tabs.attachments')
                                    @endisset
                                </a>
                            </li>
                        @endif
                        
                        @if($actityLogDatatable != null )
                            <li class="nav-item m-tabs__item">
                                <a class="nav-link m-tabs__link" href="#tab_updates" data-toggle="tab"
                                   title="@lang('core::core.tabs.updates')">
                                    @isset($baseIcons,'activity_log_label')
                                        @lang('core::core.tabs.updates')
                                    @endisset
                                </a>
                            </li>
                        @endif
                    </ul>
                @endif


                    <div class="tab-content">
                        
                        <div role="tabpanel" class="row tab-pane active" id="tab_details">
                            <div class="col-lg-12 col-md-12">
                                @foreach($customShowButtons as $btn)
                                    {!! Html::customButton($btn) !!}
                                @endforeach

                            </div>

                            @foreach($show_fields as $panelName => $panel)
                                {{ Html::section($language_file,$panelName) }}


                                @foreach($panel as $fieldName => $options)
                                    @if(isset($entity->{$fieldName}) && $entity->{$fieldName} != '')
                                    {{
                                        Html::renderField($entity,$fieldName,$options,$language_file)
                                    }}
                                    @endif
                                @endforeach

                            @endforeach

                            @include('core::crud.partial.entity_created_at')
                        </div>


                        @foreach($relationTabs as $tabKey => $tab)
                            @if(Auth::user()->hasPermissionTo($tab['permissions']['browse']))
                                <div role="tabpanel" class="row tab-pane" id="tab_{{$tabKey}}">

                                    <div class="related_module_wrapper">
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12">

                                                @if($tab['select']['allow'])

                                                    @if(Auth::user()->hasPermissionTo($tab['permissions']['update']))
                                                        <div class="select_relation_wrapper">
                                                            <a href="#" class="select btn btn-primary waves-effect modal-relation">@lang('core::core.btn.select')</a>

                                                            <div id="modal_{{$tabKey}}" class="modal fade" role="dialog">
                                                                <div class="modal-dialog modal-xl">
                                                                    <div class="modal-content">
                                                                        <div class="modal-header">
                                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                            @if(isset($tab['select']['modal_title']))
                                                                                <h4 class="modal-title">@lang($tab['select']['modal_title'])</h4>
                                                                            @endif
                                                                        </div>
                                                                        <div class="modal-body linked-records">
                                                                            <div class="col-lg-12 col-md-12 col-sm-12 linked-records">
                                                                                @include('core::crud.relation.relation',['datatable' => $tab['newRecordsTable'],'entity'=>$entity,'tab'=>$tab])
                                                                            </div>

                                                                        </div>
                                                                        <div class="modal-footer">

                                                                            @include('core::crud.relation.link',['tabkey'=>$tabKey,'entityId' => $entityIdentifier,'route'=>$tab['route']['bind_selected']])

                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    @endif
                                                @endif

                                                @if($tab['create']['allow'])
                                                    @if(Auth::user()->hasPermissionTo($tab['permissions']['create']))
                                                        <div class="create_new_relation_wrapper">
                                                            <a href="#" class="select btn btn-brand  m-btn btn-edit btn-crud modal-new-relation">@lang('core::core.btn.new')</a>

                                                                <div data-create-route="{{ route($tab['route']['create'],$tab['create']['post_create_bind']) }}" id="modal_create_{{$tabKey}}" class="modal fade" role="dialog">
                                                                    <div class="modal-dialog modal-lg">
                                                                        <div class="modal-content">
                                                                            <div class="modal-header">
                                                                                @if(isset($tab['create']['modal_title']))
                                                                                    <h4 class="modal-title">@lang($tab['create']['modal_title'])</h4>
                                                                                @endif
                                                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                            </div>
                                                                            <div class="modal-body">

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                        </div>
                                                    @endif

                                                @endif
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 linked-records"  id="linked_{{$tabKey}}">
                                                @include('core::crud.relation.relation',['datatable' => $tab['htmlTable'],'entity'=>$entity,'tab'=>$tab])
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif
                        @endforeach

                        <div role="tabpanel" class="row tab-pane" id="tab_dashboard">

                            <div class="related_module_wrapper">
                                <div class="row">
                                    <div class="row m-row--col-separator-xl">
                                        <div class="col-xl-6 col-lg-6 col-md-11 col-sm-11 col-11 mx-auto">
                        
                                            @include("dashboard::widgets.widgets")
                                            
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-11 col-sm-11 col-11 mx-auto">
                        
                                            @include("dashboard::charts.pie_chart")
                        
                                        </div>
                                        <div class="col-xl-7 col-lg-11 col-md-11 col-sm-11 col-11 mx-auto">
                        
                                            @include("dashboard::charts.container_chart")
                        
                                        </div>
                                        <div class="col-xl-5 col-lg-11 col-md-11 col-sm-11 col-11 mx-auto">

                                            @include("dashboard::last_updates.last_updates")

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        @if($commentableExtension)
                            <div role="tabpanel" class="row tab-pane" id="tab_comments">
                                <div class="col-lg-12 col-md-12">
                                    @include('core::extension.comments.list',['entity'=>$entity])
                                </div>
                            </div>
                        @endif

                        @if($attachmentsExtension)
                            <div role="tabpanel" class="row tab-pane" id="tab_attachments">

                                <div class="col-lg-12 col-md-12">
                                    @include('core::extension.attachments.list',['entity'=>$entity,'permissions'=>$permissions])
                                </div>

                            </div>
                        @endif


                        @if($actityLogDatatable !=  null )
                            <div role="tabpanel" class="row tab-pane" id="tab_updates">

                                <div class="table-responsive col-lg-12 col-md-12">
                                    @include('core::extension.activity_log.table')
                                </div>
                            </div>
                        @endif
                    </div>

                </div>
            </div>
        </div>
    </div>

    @foreach($includeViews as $v)
        @include($v)
    @endforeach

@endsection

@push('css')
    @foreach($cssFiles as $file)
        <link rel="stylesheet" href="{!! Module::asset($moduleName.':css/'.$file) !!}"></link>
    @endforeach
@endpush

@push('scripts')

    <script src="{!! Module::asset('core:js/BAP_Charts.js') !!}"></script>

@endpush

