<?php
namespace Modules\Places\Datatables\Tabs;

use Modules\Places\Entities\Place;
use Modules\Companies\Entities\Company;
use Yajra\DataTables\EloquentDataTable;
use Modules\Platform\User\Entities\User;
use Modules\Platform\Core\Helper\DataTableHelper;
use Modules\Platform\Core\Datatable\RelationDataTable;

/**
 * Class CampaignsContactsDatatable
 * @package Modules\Campaigns\Datatables\Tabs
 */
class PlaceUsersDatatable extends RelationDataTable
{
    const SHOW_URL_ROUTE = 'settings.users.show';
    const EDIT_URL_ROUTE = 'settings.users.edit';
    const REMOVE_URL_ROUTE = 'settings.users.destroy';
 
    protected $unlinkRoute = 'places.users.unlink';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query) {

        $dataTable = new EloquentDataTable($query);

        if(\Auth::user()->hasRole('admin')){
            $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE, 'places_');
        }
        else{
            $this->applyLinks($dataTable, 'users.show', 'users.edit', 'users.destroy', 'places_');
        }   

        return $dataTable;
    }


    /**
     * Get query source of dataTable.
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(User $model) {

        $query = $model->newQuery()
        ->select([
            'users.id',
            'users.company_id',
            'users.place_id',
            'users.name',
            'users.email',
            'users.person_tax_number',
            'users.home_phone',
            'users.mobile_phone',
            'users.address_city',
            'users.address_state',
        ]);

        return $query;
    }


    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html() {

        $currentColumn = 0;
        $columnFilters = [];

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];
        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];
        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];

        return $this->builder()
            ->columns($this->getColumns())
            ->setTableId('PlaceUsersDatatable' . $this->tableSuffix)
            ->minifiedAjax(route($this->route, ['entityId' => $this->entityId]))
            ->setTableAttribute('class', 'table responsive table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",
                'stateSave' => true,
                'columnFilters' => $columnFilters,
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true
            ]);
    }

    /**
     * @return array
     */
    protected function getColumns() {

        $unlink = [
            'unlink' => [
                'data' => 'unlink',
                'title' => '',
                'data_type' => 'unlink',
                'orderable' => false,
                'searchable' => false,
            ]
        ];

        $check_selection = [
            'check_select' => [
                'data' => 'check_select',
                'title' => '',
                'data_type' => 'check_select',
                'orderable' => false,
                'searchable' => false,
            ]
        ];

        $data = [];

        $data += [

            'name' => [
                'data' => 'name', 
                'title' => trans('user::users.table.first_name'), 
                'data_type' => 'text'
            ],
            'email' => [
                'data' => 'email', 
                'title' => trans('user::users.table.email'), 
                'data_type' => 'email'
            ],
            'person_tax_number' => [
                'data' => 'person_tax_number', 
                'title' => trans('user::users.table.person_tax_number'), 
                'data_type' => 'text'
            ],
            'home_phone' => [
                'data' => 'home_phone', 
                'title' => trans('user::users.table.home_phone'), 
                'data_type' => 'text'
            ],
            'mobile_phone' => [
                'data' => 'mobile_phone', 
                'title' => trans('user::users.table.mobile_phone'), 
                'data_type' => 'text'
            ],
        ];

        return $data;
    }
}
