<?php

namespace Modules\Maintenances\Http\Forms;


use Kris\LaravelFormBuilder\Form;

use Modules\Platform\Core\Helper\FormHelper;
use Modules\Companies\Entities\Company;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Asset;





class MaintenanceForm extends Form
{
    public function buildForm()
    {
        $assets = NULL;
        if (\Auth::user()->hasRole('admin')) {
            $assets = Asset::all()->pluck('item','id')->toArray();

        } else if (\Auth::user()->hasRole('chefe')) {
            $assets = Asset::where('company_id', \Auth::user()->company_id)->pluck('item','id')->toArray();

        } else {
            $assets = Asset::where('place_id', \Auth::user()->place_id)->pluck('item','id')->toArray();
        }

        if (isset($this->model['relatedEntity']) && isset($this->model['asset_id'])) {
            $this->add('asset_id', 'select', [
                'choices' => $assets,
                'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                'label' => trans('maintenances::maintenances.form.asset_id'),
                'empty_value' => trans('core::core.empty_select')
            ]);

            $this->model['company_id'] = Asset::find($this->model['asset_id'])['company_id'];
            $this->model['place_id'] = Asset::find($this->model['asset_id'])['place_id'];
        } else {
            $this->add('asset_id', 'select', [
                'choices' => $assets,
                'attr' => ['class' => 'select2 pmd-select2 form-control'],
                'label' => trans('maintenances::maintenances.form.asset_id'),
                'empty_value' => trans('core::core.empty_select')
            ]);
        }

        $this->add('maintenance_company', 'text', [
            'label' => trans('maintenances::maintenances.form.maintenance_company'),
        ]);

        // $this->add('company_id', 'select', [
        //     'choices' => Company::all()->pluck('name','id')->toArray(),
        //     'attr' => ['class' => 'select2 pmd-select2 form-control'],
        //     'label' => trans('maintenances::maintenances.form.company_id'),
        //     'empty_value' => trans('core::core.empty_select')
        // ]);


        // $this->add('place_id', 'select', [
        //     'choices' => Place::all()->pluck('identifier_name','id')->toArray(),
        //     'attr' => ['class' => 'select2 pmd-select2 form-control'],
        //     'label' => trans('maintenances::maintenances.form.place_id'),
        //     'empty_value' => trans('core::core.empty_select')
        // ]);

        $this->add('maintenance_date', 'dateType', [
            'label' => trans('maintenances::maintenances.form.maintenance_date'),
        ]);



        $this->add('value', 'number', [
            'label' => trans('maintenances::maintenances.form.value'),
        ]);



        $this->add('notes', 'textarea', [
            'label' => trans('maintenances::maintenances.form.notes'),
        ]);






        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }

}