<?php

namespace Modules\Maintenances\Http\Controllers;

use Modules\Maintenances\Datatables\MaintenanceDatatable;
use Modules\Maintenances\Entities\Maintenance;
use Modules\Maintenances\Http\Forms\MaintenanceForm;
use Modules\Maintenances\Http\Requests\MaintenancesRequest;
use Modules\Platform\Core\Http\Controllers\ModuleCrudController;
use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Repositories\GenericRepository;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Asset;

class MaintenancesController extends ModuleCrudController
{

    protected $datatable = MaintenanceDatatable::class;
    protected $formClass = MaintenanceForm::class;
    protected $storeRequest = MaintenancesRequest::class;
    protected $updateRequest = MaintenancesRequest::class;
    protected $entityClass = Maintenance::class;

    protected $moduleName = 'maintenances';

    protected $permissions = [
        'browse' => 'maintenances.browse',
        'create' => 'maintenances.create',
        'update' => 'maintenances.update',
        'destroy' => 'maintenances.destroy'
    ];

    protected $moduleSettingsLinks = [
    ];

    protected $settingsPermission = 'maintenances.settings';

    protected $showFields = [

        'information' => [

            'asset_id' => [
                'type' => 'manyToOne',
                'relation' => 'Asset',
                'column' => 'item'
            ],

            'maintenance_company' => [
                'type' => 'text',
            ],

            'maintenance_date' => [
                'type' => 'date',
            ],


            'value' => [
                'type' => 'decimal',
            ],

        ],

        
        'notes' => [

            'notes' => [
                'type' => 'text',
            ],

        ],



    ];

    protected $languageFile = 'maintenances::maintenances';

    protected $routes = [
        'index' => 'maintenances.maintenances.index',
        'create' => 'maintenances.maintenances.create',
        'show' => 'maintenances.maintenances.show',
        'edit' => 'maintenances.maintenances.edit',
        'store' => 'maintenances.maintenances.store',
        'destroy' => 'maintenances.maintenances.destroy',
        'update' => 'maintenances.maintenances.update'
    ];

    public function __construct()
    {
        parent::__construct();

    }

    /**
     * Store entity
     *
     * @return \Illuminate\Http\JsonResponse|\Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store()
    {
        $request = \App::make($this->storeRequest ?? Request::class);

        $mode = $request->get('entityCreateMode', self::FORM_MODE_FULL);

        if ($this->permissions['create'] != '' && !\Auth::user()->hasPermissionTo($this->permissions['create'])) {
            if ($mode == self::FORM_MODE_SIMPLE) {
                return response()->json([
                    'type' => 'error',
                    'message' => trans('core::core.entity.you_dont_have_access'),
                    'action' => 'show_message'
                ]);
            }
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $repository = $this->getRepository();

        $storeValues = $this->form($this->formClass)->getFieldValues(true);

        if ($mode == self::FORM_MODE_SIMPLE) {

            //Bind related element
            $relatedEntityId = $request->get('relatedEntityId');
            $relationType = $request->get('relationType', null);
            $relatedField = $request->get('relatedField');
            $relatedEntity = $request->get('relatedEntity');

            if ($relationType != null) { // Relation type is not null

                $relationEntityRepos = \App::make(GenericRepository::class);
                $relationEntityRepos->setupModel($relatedEntity);

                $relationEntity = $relationEntityRepos->findWithoutFail($relatedEntityId);

                if ($relationType == 'oneToMany') {
                    $storeValues[$relatedField] = $relationEntity->id;
                }
            }
        }

        $input = [];
        foreach($storeValues as $key => $value){
            if($value === ''){
                unset($storeValues[$key]);
            }
        }

        $storeValues['company_id'] = Asset::find($storeValues['asset_id'])->company_id;
        $storeValues['place_id'] = Asset::find($storeValues['asset_id'])->place_id;
        
        $entity = $repository->createEntity($storeValues, \App::make($this->entityClass));


        $entity = $this->setupAssignedTo($entity, $request, true);
        $entity->save();


        if (config('bap.record_assigned_notification_enabled')) {

            if ($entity instanceof Ownable) {
                if ($entity->getOwner() != null && $entity->getOwner() instanceof User) {
                    if ($entity->getOwner()->id != \Auth::user()->id) { // Dont send notification for myself
                        try {
                            $commentOn = $entity->name;
                            $commentOn = ' - ' . $commentOn;
                        } catch (\Exception $exception) {
                            $commentOn = '';
                        }

                        $placeholder = new NotificationPlaceholder();

                        $placeholder->setRecipient($entity->getOwner());
                        $placeholder->setAuthorUser(\Auth::user());
                        $placeholder->setAuthor(\Auth::user()->name);
                        $placeholder->setColor('bg-green');
                        $placeholder->setIcon('assignment');
                        $placeholder->setContent(trans('notifications::notifications.new_record', ['user' => \Auth::user()->name]) . $commentOn);

                        $placeholder->setUrl(route($this->routes['show'], $entity->id));

                        $entity->getOwner()->notify(new GenericNotification($placeholder));
                    }
                }
            }
        }

        if ($mode == self::FORM_MODE_SIMPLE) {

            //Bind related element
            $relatedEntityId = $request->get('relatedEntityId');
            $relationType = $request->get('relationType', null);
            $relatedField = $request->get('relatedField');
            $relatedEntity = $request->get('relatedEntity');

            if ($relationType != null) { // Relation type is not null

                $relationEntityRepos = \App::make(GenericRepository::class);
                $relationEntityRepos->setupModel($relatedEntity);


                $relationEntity = $relationEntityRepos->findWithoutFail($relatedEntityId);


                if ($relationType == 'manyToMany') {
                    $entity->{$relatedField}()->attach($relationEntity->id);
                }
            }

            return response()->json([
                'type' => 'success',
                'message' => trans('core::core.entity.created'),
                'action' => 'refresh_datatable'
            ]);
        }

        if(! isset($this->settingName) ){
            $msg = $this->moduleName. '::' .$this->moduleName.'.created';
        }
        else{
            $msg = $this->moduleName. '::' .$this->moduleName.'.'.$this->settingName.'.created';
        }

        flash(trans($msg))->success();

        return redirect(route($this->routes['index']));
    }

}
