<?php

namespace Modules\Dashboard\Http\Controllers;

use Illuminate\Http\Request;
use Modules\Asset\Service\AssetService;
use Modules\Supplier\Service\SupplierService;
use Modules\Platform\User\Service\UserService;
use Modules\Dashboard\Datatables\DashboardDatatable;
use Modules\Collaborator\Service\CollaboratorService;
use Modules\Platform\Core\Datatable\Scope\OwnableEntityScope;
use Modules\Platform\Core\Http\Controllers\AppBaseController;

/**
 * Class DashboardController
 * @package Modules\Dashboard\Http\Controllers
 */
class DashboardController extends AppBaseController
{

    protected $datatable = DashboardDatatable::class;

    /**
     * Dashboard
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function index(Request $request)
    {
        $datatable = \App::make($this->datatable);
        $datatable->addScope(new OwnableEntityScope(\Auth::user(), 'dashboard'));
        $datatable->setTableId('RelatedModalTable');
        $datatable->setAjaxSource(route('dashboard'));

        $userService = \App::make(UserService::class);
        $collaboratorService = \App::make(CollaboratorService::class);
        $assetService = \App::make(AssetService::class);
        $supplierService = \App::make(SupplierService::class);

        $assetsCount = $assetService->count();
        $usersCount = $userService->count();
        $collaboratorsCount = $collaboratorService->count();
        $suppliersCount = $supplierService->count();

        if(\Auth::user()->hasRole('admin')){
            $dataPieChart = $assetService->getByCompanies();
        }
        else{
            $dataPieChart = $assetService->getByCategory();
        }

        $dataContainerChart = $assetService->getBystatus();

        $lastUpdates = $assetService->lastUpdates();

        \JavaScript::put([
            'dataPieChart' => json_encode($dataPieChart),
            'dataContainerChart' => json_encode($dataContainerChart),
        ]);

        $moduleName = 'dashboard';

        return $datatable = $datatable->render('dashboard::index', 
            compact(
                'usersCount',
                'collaboratorsCount',
                'assetsCount',
                'suppliersCount',
                'dataPieChart',
                'dataContainerChart',
                'lastUpdates',
                'moduleName'
            )
        );


    }
}
