<?php

Route::group(['middleware' => ['web','permission:companies.browse'],'prefix'=>'companies','as'=>'companies.', 'namespace' => 'Modules\Companies\Http\Controllers'], function()
{
    Route::get('/',function(){
       return redirect()->route('companies.companies.index');
    });

    Route::group(['middleware' => ['web','permission:companies.settings']], function(){ });

    // Places Routes
    Route::get('companies/places-selection/{entityId}', ['as'=>'places.selection','uses'=> 'Tabs\CompanyPlacesController@selection']);
    Route::get('companies/places-linked/{entityId}', ['as'=>'places.linked','uses'=> 'Tabs\CompanyPlacesController@linked']);
    Route::post('companies/places-unlink', ['as'=>'places.unlink','uses'=> 'Tabs\CompanyPlacesController@unlink']);
    Route::post('companies/places-link', ['as'=>'places.link','uses'=> 'Tabs\CompanyPlacesController@link']);

    // Collaborators Routes
    Route::get('companies/collaborators-selection/{entityId}', ['as'=>'collaborators.selection','uses'=> 'Tabs\CompanyCollaboratorsController@selection']);
    Route::get('companies/collaborators-linked/{entityId}', ['as'=>'collaborators.linked','uses'=> 'Tabs\CompanyCollaboratorsController@linked']);
    Route::post('companies/collaborators-unlink', ['as'=>'collaborators.unlink','uses'=> 'Tabs\CompanyCollaboratorsController@unlink']);
    Route::post('companies/collaborators-link', ['as'=>'collaborators.link','uses'=> 'Tabs\CompanyCollaboratorsController@link']);

    // Assets Routes
    Route::get('companies/assets-selection/{entityId}', ['as'=>'assets.selection','uses'=> 'Tabs\CompanyAssetsController@selection']);
    Route::get('companies/assets-linked/{entityId}', ['as'=>'assets.linked','uses'=> 'Tabs\CompanyAssetsController@linked']);
    Route::post('companies/assets-unlink', ['as'=>'assets.unlink','uses'=> 'Tabs\CompanyAssetsController@unlink']);
    Route::post('companies/assets-link', ['as'=>'assets.link','uses'=> 'Tabs\CompanyAssetsController@link']);
    
    Route::resource('companies', 'CompaniesController');

    // Ajax data-source
    Route::get('/get-places/{company_id}', 'CompaniesController@getPlaces');
    Route::get('/get-suppliers/{company_id}', 'CompaniesController@getSuppliers');
    Route::get('/get-areas/{company_id}', 'CompaniesController@getAreas');
    Route::get('/get-status/{company_id}', 'CompaniesController@getStatus');
    Route::get('/get-collaborators/{company_id}', 'CompaniesController@getCollaborators');
    Route::get('/get-categories/{company_id}', 'CompaniesController@getCategories');

});
