<?php

namespace Modules\Companies\Http\Controllers\Tabs;

use Modules\Companies\Entities\Company;
use Modules\Assets\Entities\Asset;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;
use Modules\Companies\Datatables\Tabs\CompanyAssetsDatatable;

/**
 * Class AccountsTicketsController
 * @package Modules\Assets\Http\Controllers
 */
class CompanyAssetsController extends ModuleCrudRelationController
{
    protected $datatable = CompanyAssetsDatatable::class;

    protected $ownerModel = Company::class;

    protected $relationModel = Asset::class;

    protected $ownerModuleName = 'companies';

    protected $relatedModuleName = 'assets';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'assets';

    protected $relationTableName = 'assets';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Company';
}
