<?php
namespace Modules\Companies\Datatables\Tabs;

use Modules\Places\Entities\Place;
use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Datatable\RelationDataTable;
use Modules\Platform\Core\Helper\DataTableHelper;
use Yajra\DataTables\EloquentDataTable;

/**
 * Class CampaignsContactsDatatable
 * @package Modules\Campaigns\Datatables\Tabs
 */
class CompanyPlacesDatatable extends RelationDataTable
{
    const SHOW_URL_ROUTE = 'places.places.show';
    const EDIT_URL_ROUTE = 'places.places.edit';
    const REMOVE_URL_ROUTE = 'places.places.destroy';

    protected $unlinkRoute = 'companies.places.unlink';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE, 'companies_');

        return $dataTable;
    }


    /**
     * Get query source of dataTable.
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Place $model)
    {
        $query = $model->newQuery()
        ->select([
            'places.id',
            'places.company_id',
            'places.identifier_name',
            'places.city',
            'places.state',
            'places.street',
            'places.number',
            'places.complement',
            'places.neighborhood',
            'places.postal_code',
        ]);

        return $query;

    }


    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {

        $currentColumn = 0;
        $columnFilters = [];

        if(\Auth::user()->hasRole('admin')){

            $data_companies = [];
            foreach (Company::all()->toArray() as $company){
                $data_companies[] = [
                    'value' => $company['id'],
                    'label' => $company['name'],
                ];
            }

            $columnFilters[] = [
                    'column_number' => $currentColumn++,
                    'filter_type' => 'select',
                    'select_type' => 'select2',
                    'select_type_options' => [
                        'theme' => "bootstrap",
                        'width' => '100%'
                    ],
                    'data' => $data_companies                    
                ];
        }

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];
        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];
        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];

        return $this->builder()
            ->columns($this->getColumns())
            ->setTableId('CompanyPlacesDatatable' . $this->tableSuffix)
            ->minifiedAjax(route($this->route, ['entityId' => $this->entityId]))

            ->setTableAttribute('class', 'table responsive table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",

                'stateSave' => true,
                'columnFilters' => $columnFilters,
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true

            ]);
    }

    /**
     * @return array
     */
    protected function getColumns()
    {

        $unlink = [
            'unlink' => [
                'data' => 'unlink',
                'title' => '',
                'data_type' => 'unlink',
                'orderable' => false,
                'searchable' => false,

            ]
        ];

        $check_selection = [
            'check_select' => [
                'data' => 'check_select',
                'title' => '',
                'data_type' => 'check_select',
                'orderable' => false,
                'searchable' => false,
            ]
        ];

        $data = [];

        $data += [

            'identifier_name' => [
                'data' => 'identifier_name',
                'title' => trans('places::places.table.identifier_name'),
                'data_type' => 'text'
            ],
            'city' => [
                'data' => 'city',
                'title' => trans('places::places.table.city'),
                'data_type' => 'text'
            ],
            'state' => [
                'data' => 'state',
                'title' => trans('places::places.table.state'),
                'data_type' => 'text'
            ],
            'postal_code' => [
                'data' => 'postal_code',
                'title' => trans('places::places.table.postal_code'),
                'data_type' => 'text'
            ],
            'actions' => ['title' => trans('core::core.table.actions'), 'data_type' => 'actions', 'orderable' => false],
        ];

        return $data;
    }
}
