<?php

namespace Modules\Collaborator\Service;

use Modules\Collaborators\Entities\Collaborator;

/**
 * Class CollaboratorService
 * @package Modules\Collaborator\Service
 */
class CollaboratorService
{
    /**
     * Count of collaborators according to access rules
     *
     * @return integer
     */
    public function count()
    {
        if(\Auth::user()->hasRole('admin')){

            return Collaborator::count();
        }

        elseif(\Auth::user()->hasRole('chefe')){

            return Collaborator::where('company_id',\Auth::user()->company_id)->count();
        }

        elseif(\Auth::user()->hasRole('gerente')){

            return Collaborator::where('place_id',\Auth::user()->place_id)->count();
        }

    }

    /**
     * Count of collaborators according to some company
     *
     * @return integer
     */
    public function countByCompany($company_id)
    {
        return Collaborator::where('company_id',$company_id)->count();
    }


    /**
     * Count of collaborators according to some place
     *
     * @return integer
     */
    public function countByPlace($place_id)
    {
        return Collaborator::where('place_id',$place_id)->count();
    }

}
