<?php

namespace Modules\Collaborators\Http\Controllers;

use Modules\Collaborators\Datatables\CollaboratorDatatable;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Collaborators\Http\Forms\CollaboratorForm;
use Modules\Collaborators\Http\Requests\CollaboratorsRequest;
use Modules\Platform\Core\Http\Controllers\ModuleCrudController;

class CollaboratorsController extends ModuleCrudController
{

    protected $datatable = CollaboratorDatatable::class;
    protected $formClass = CollaboratorForm::class;
    protected $storeRequest = CollaboratorsRequest::class;
    protected $updateRequest = CollaboratorsRequest::class;
    protected $entityClass = Collaborator::class;

    protected $moduleName = 'collaborators';

    protected $permissions = [
        'browse' => 'collaborators.browse',
        'create' => 'collaborators.create',
        'update' => 'collaborators.update',
        'destroy' => 'collaborators.destroy'
    ];

    protected $moduleSettingsLinks = [

        ['route' => 'collaborators.area.index', 'label' => 'settings.area'],

    ];

    protected $settingsPermission = 'collaborators.settings';

    protected $showFields = [

        'information' => [
                
            'company_id' => [
                'type' => 'hidden',
                'col-class' => 'col-12'
            ],

            'place_id' => [
                'type' => 'manyToOne', 
                'relation' => 'Place',
                'column' => 'identifier_name',
                'belongs_to' => 'Place',
                'col-class' => 'col-12'
            ],

            'area_id' => [
                'type' => 'manyToOne', 
                'relation' => 'Area', 
                'column' => 'name',
                'belongs_to' => 'Area',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'name' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'person_tax_number' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'email' => [
                'type' => 'email',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'birthday' => [
                'type' => 'date',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'phone' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],

            'mobile' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
        ],
    
        'address' => [
            
            'city' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
            'state' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
            'street' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
            'number' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
            'neighborhood' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
            'complement' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
            'postal_code' => [
                'type' => 'text',
                'col-class' => 'col-xl-6 col-lg-6 col-md-6 col-12'
            ],
                
        ],

        'notes' => [

            'notes' => [
                'type' => 'text',
                'col-class' => 'col-12'
            ],
                
        ],

    ];

    protected $languageFile = 'collaborators::collaborators';

    protected $routes = [
        'index' => 'collaborators.collaborators.index',
        'create' => 'collaborators.collaborators.create',
        'show' => 'collaborators.collaborators.show',
        'edit' => 'collaborators.collaborators.edit',
        'store' => 'collaborators.collaborators.store',
        'destroy' => 'collaborators.collaborators.destroy',
        'update' => 'collaborators.collaborators.update'
    ];

    protected $jsFiles = [
        'BAP_Collaborators.js',
    ];

    public function __construct()
    {
        parent::__construct();

    }

}
