<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class collaboratorMigrationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {

        Schema::create('collaborators', function (Blueprint $table) {

            $table->increments('id');
        
            $table->integer('company_id')->unsigned()->nullable();
            $table->foreign('company_id')->references('id')->on('companies');

            $table->integer('place_id')->unsigned()->nullable();
            $table->foreign('place_id')->references('id')->on('places');

            $table->integer('area_id')->unsigned()->nullable();
            $table->foreign('area_id')->references('id')->on('areas');

            $table->string('name')->nullable();

            $table->string('email')->nullable();
                
            $table->string('person_tax_number')->nullable();
        
            $table->string('birthday')->nullable();
        
            $table->string('phone')->nullable();
        
            $table->string('mobile')->nullable();
            
            $table->string('city')->nullable();
        
            $table->string('state')->nullable();
        
            $table->string('street')->nullable();
        
            $table->string('number')->nullable();
        
            $table->string('neighborhood')->nullable();
        
            $table->string('complement')->nullable();
        
            $table->string('postal_code')->nullable();
            
            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

        });

        

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::dropIfExists('collaborators');
    }
}
