<?php

namespace Modules\Assets\Http\Forms;

use Kris\LaravelFormBuilder\Form;

use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Helper\FormHelper;

class CategoryForm extends Form 
{
    public function buildForm()
    {

        $this->add('name', 'text', [
            'label' => trans('core::core.form.name'),
        ]);

        $this->add('notes', 'text', [
            'label' => trans('core::core.form.note'),
        ]);

        if($this->model){

            if($this->model->special_fields != ''){
                $qtd_special_fields = 1;
                while(isset($this->model->{'special_field_'.$qtd_special_fields})){
                    $this->add('special_field_'.$qtd_special_fields, 'text', [
                        'label' => trans('assets::assets.categories.form.special_fields'),
                        'attr' => [
                            'name' => 'special_field_'.$qtd_special_fields, 
                            'id' => 'special_field_'.$qtd_special_fields, 
                            'class' => 'special_field form-control' 
                        ],
                    ]);
                    
                    $qtd_special_fields++;
                }
            }
            else{
                $this->add('special_field_1', 'text', [
                    'label' => trans('assets::assets.categories.form.special_fields'),
                    'attr' => [
                        'name' => 'special_field_1', 
                        'id' => 'special_field_1', 
                        'class' => 'special_field form-control' 
                    ],
                ]);
            
            }
        }
        else{
            $this->add('special_field_1', 'text', [
                'label' => trans('assets::assets.categories.form.special_field_1'),
                'attr' => [
                    'name' => 'special_field_1', 
                    'id' => 'special_field_1', 
                    'class' => 'special_field form-control' 
                ],
            ]);
        }

        $this->add('button', 'button', [
            'label' => trans('assets::assets.categories.form.add_field'),
            'attr' => ['class' => 'btn btn-success waves-effect add_special_field col-3 offset-9'],
        ]);

        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary waves-effect', 'style' => 'margin-top:30px']
        ]);
    }

}

