<?php

namespace Modules\Assets\Entities;

use Illuminate\Database\Eloquent\Model;

/**
 * @property int $id
 * @property int $company_id
 * @property int $place_id
 * @property int $status_id
 * @property int $quantity
 * @property string $created_at
 * @property string $updated_at
 * @property Company $company
 * @property Place $place
 * @property Status $status
 */
class AssetStatusLog extends Model
{
    /**
     * The table associated with the model.
     * 
     * @var string
     */
    protected $table = 'assets_status_log';

    /**
     * @var array
     */
    protected $fillable = ['company_id', 'place_id', 'status_id', 'quantity', 'created_at', 'updated_at'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function company()
    {
        return $this->belongsTo('App\Company');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function place()
    {
        return $this->belongsTo('App\Place');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status()
    {
        return $this->belongsTo('App\Status');
    }
}
