<?php

namespace Modules\Assets\Entities;


use Carbon\Carbon;
use Modules\Maintenances\Entities\Maintenance;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Status;
use Modules\Assets\Entities\Category;
use Illuminate\Database\Eloquent\Model;
use Modules\Companies\Entities\Company;
use Modules\Collaborators\Entities\Area;
use Modules\Suppliers\Entities\Supplier;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Collaborators\Entities\Collaborator;
use Modules\Platform\Core\Helper\ActivityLogHelper;

/**
 * @property int $id
 * @property int $company_id
 * @property int $place_id
 * @property int $category_id
 * @property int $area_id
 * @property int $status_id
 * @property int $responsible
 * @property string $asset_number
 * @property string $serial_number_1
 * @property string $serial_number_2
 * @property string $image_path
 * @property string $item
 * @property string $category_special_fields
 * @property string $model
 * @property string $purchase_date
 * @property string $age
 * @property string $purchase_value
 * @property string $conservation_state
 * @property string $useful_life
 * @property string $current_value
 * @property string $notes
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property Area $area
 * @property Category $category
 * @property Company $company
 * @property Place $place
 * @property Collaborator $collaborator
 * @property Status $status
 */
class Asset extends Model
{
    use SoftDeletes, LogsActivity;

    protected static $logAttributes = [
        'Place.identifier_name', 
        'Category.name',
        'Area.name',
        'Status.name',
        'asset_number', 
        'serial_number_1', 
        'serial_number_2', 
        'image_path', 
        'item', 
        'model',
        'responsible', 
        'purchase_date', 
        'age',
        'purchase_value', 
        'conservation_state', 
        'useful_life', 
        'current_value', 
        'notes',
    ];

    /**
     * @var array
     */
    protected $fillable = ['company_id', 'place_id', 'category_id', 'area_id', 'status_id', 'responsible', 'supplier_id', 'asset_number', 'serial_number_1', 'serial_number_2', 'image_path', 'item', 'category_special_fields', 'model', 'purchase_date', 'age', 'purchase_value', 'conservation_state', 'useful_life', 'current_value', 'notes', 'created_at', 'updated_at', 'deleted_at'];


        /**
     * @param  Model $model
     * @param  string $attribute
     * @return  array
     */
    protected static function getRelatedModelAttributeValue(Model $model, string $attribute): array
    {
        return ActivityLogHelper::getRelatedModelAttributeValue($model, $attribute);
    }


    /**
    * Required to proper parse date provided in user date format
    * @param  $value
    */
    public function setpurchaseDateAttribute($value)
    {
        $parsed = Carbon::parse($value);

        $this->attributes['purchase_date'] = $parsed;
    }

    public function getMaintenanceTotalAttribute()
    {
        $total = 0;
        
        foreach($this->maintenances as $maintenance) {
            $total += $maintenance->value;
        }

        return number_format($total,2,',','.');

    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function place()
    {
        return $this->belongsTo(Place::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function collaborator()
    {
        return $this->belongsTo(Collaborator::class, 'responsible');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function status()
    {
        return $this->belongsTo(Status::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function maintenances()
    {
        return $this->hasMany(Maintenance::class);
    }

}

