<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AssetMigrationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {

        Schema::create('assets', function (Blueprint $table) {

            $table->increments('id');
        
            $table->integer('company_id')->unsigned()->nullable();
            $table->foreign('company_id')->references('id')->on('companies');

            $table->integer('place_id')->unsigned()->nullable();
            $table->foreign('place_id')->references('id')->on('places');

            $table->string('asset_number')->nullable();
        
            $table->string('serial_number_1')->nullable();
        
            $table->string('serial_number_2')->nullable();
        
            $table->string('image_path')->nullable();
        
            $table->string('item')->nullable();
        
            $table->integer('category_id')->unsigned()->nullable();
            $table->foreign('category_id')->references('id')->on('categories');

            $table->string('category_special_fields')->nullable();

            $table->integer('area_id')->unsigned()->nullable();
            $table->foreign('area_id')->references('id')->on('areas');
        
            $table->string('responsible')->nullable();

            $table->string('model')->nullable();
        
            $table->date('purchase_date')->nullable();
        
            $table->string('age')->nullable();
        
            $table->string('purchase_value')->nullable();
        
            $table->string('conservation_state')->nullable();
        
            $table->string('useful_life')->nullable();
        
            $table->integer('status_id')->unsigned()->nullable();
            $table->foreign('status_id')->references('id')->on('status');
        
            $table->string('current_value')->nullable();
            
            $table->text('notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assets');
    }
}
