<?php

namespace Modules\Suppliers\Http\Forms;


use Kris\LaravelFormBuilder\Form;

use Modules\Places\Entities\Place;
use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Helper\FormHelper;


class SupplierForm extends Form
{
    public function buildForm()
    {

        if(\Auth::user()->hasRole('admin')){

            $this->add('company_id', 'choice', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('suppliers::suppliers.form.company'),
            ]);
        }
        else{

            $this->add('company_id', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => \Auth::user()->company_id
            ]);
        }
        
        $this->add('email', 'text', [
            'label' => trans('suppliers::suppliers.form.email'),
        ]);

        $this->add('person_type', 'choice', [
            'choices' => ['Pessoa Física' => 'Pessoa Física', 'Pessoa Jurídica' => 'Pessoa Jurídica'],
            'label' => trans('suppliers::suppliers.form.person_type'),
            'empty_value' => trans('core::core.empty_select'),
        ]);

        $this->add('person_tax_number-company_tax_number', 'text', [
            'attr' => ['class' => 'form-control'],
            'label' => trans('suppliers::suppliers.form.person_tax_number-company_tax_number'),
        ]);

        $this->add('fantasy_name', 'text', [
            'label' => trans('suppliers::suppliers.form.fantasy_name'),
        ]);

        $this->add('responsible_name', 'text', [
            'label' => trans('suppliers::suppliers.form.responsible_name'),
        ]);

        $this->add('phone', 'text', [
            'attr' => ['class' => 'form-control phone'],
            'label' => trans('suppliers::suppliers.form.phone'),
        ]);

        $this->add('mobile', 'text', [
            'attr' => ['class' => 'form-control mobile'],
            'label' => trans('suppliers::suppliers.form.mobile'),
        ]);

        $this->add('city', 'text', [
            'label' => trans('suppliers::suppliers.form.city'),
        ]);

        $this->add('state', 'text', [
            'label' => trans('suppliers::suppliers.form.state'),
        ]);

        $this->add('street', 'text', [
            'label' => trans('suppliers::suppliers.form.street'),
        ]);

        $this->add('number', 'text', [
            'label' => trans('suppliers::suppliers.form.number'),
        ]);

        $this->add('neighborhood', 'text', [
            'label' => trans('suppliers::suppliers.form.neighborhood'),
        ]);

        $this->add('complement', 'text', [
            'label' => trans('suppliers::suppliers.form.complement'),
        ]);

        $this->add('postal_code', 'text', [
            'attr' => ['class' => 'form-control cep'],
            'label' => trans('suppliers::suppliers.form.postal_code'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('suppliers::suppliers.form.notes'),
        ]);
                
        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }

}