<?php

namespace Modules\Reports\Http\Controllers;

use PDF;
use Illuminate\Http\Request;
use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Modules\Asset\Service\AssetService;
use Modules\Companies\Entities\Company;
use Modules\Reports\Http\Forms\ReportForm;
use Kris\LaravelFormBuilder\FormBuilderTrait;
use Modules\Reports\Datatables\ReportDatatable;
use Modules\Platform\Core\Datatable\Scope\OwnableEntityScope;
use Modules\Platform\Core\Http\Controllers\AppBaseController;

class ReportsController extends AppBaseController
{
    use FormBuilderTrait;

    protected $datatable = ReportDatatable::class;

    protected $formClass = ReportForm::class;

    /**
     * Reports
     * @return \Illuminate\View\View
     */
    public function index(Request $request) {

        $data = $request->all();

        $assetService = \App::make(AssetService::class);
        $datatable = \App::make($this->datatable);

        $datatable->setTableId('RelatedModalTable');

        if($request->exists('place') && $request->exists('company')){
            $request->session()->put('placeReport',$data['place']);
            $request->session()->put('companyReport',$data['company']);
        }

        if($request->exists('company') && $request->get('company') != null){

            if($request->exists('place') && $request->get('place') != ''){

                $datatable->setQueryType(ReportDatatable::QUERY_BY_PLACE);
                $datatable->setIdQuery($request->get('place'));
                $assetsCount = $assetService->countByPlace($request->get('place'));
                $dataPieChart = $assetService->getByCategory(null,$request->get('place'));
                $dataContainerChart = $assetService->getBystatus($request->get('company'),$request->get('place'));
                $reportLink = route('reports.pdfplacereport',[$request->session()->get('companyReport'),$request->session()->get('placeReport')]);
            }
            else {

                $datatable->setQueryType(ReportDatatable::QUERY_BY_COMPANY);
                $datatable->setIdQuery($request->get('company'));
                $assetsCount = $assetService->countByCompany($request->get('company'));
                $dataPieChart = $assetService->getByCategory($request->get('company'));
                $dataContainerChart = $assetService->getBystatus($request->get('company'));
                $reportLink = route('reports.pdfcompanyreport', $request->get('company'));
            }
        }

        else {

            if(\Auth::user()->hasRole('admin')){

                $datatable->setQueryType(ReportDatatable::GENERAL_QUERY);
                $assetsCount = $assetService->generalCount();
                $dataPieChart = $assetService->getByCategory();
                $dataContainerChart = $assetService->getBystatus();
                $reportLink = route('reports.pdfreport');
            }
            elseif(\Auth::user()->hasRole('chefe')){

                $datatable->setQueryType(ReportDatatable::QUERY_BY_COMPANY);
                $datatable->setIdQuery(\Auth::user()->company_id);
                $assetsCount = $assetService->countByCompany(\Auth::user()->company_id);
                $dataPieChart = $assetService->getByCategory(\Auth::user()->company_id);
                $dataContainerChart = $assetService->getBystatus(\Auth::user()->company_id,\Auth::user()->place_id);
                $reportLink = route('reports.pdfcompanyreport', \Auth::user()->company_id);
            }
            elseif(\Auth::user()->hasRole('gerente')){

                $datatable->setQueryType(ReportDatatable::QUERY_BY_PLACE);
                $datatable->setIdQuery(\Auth::user()->place_id);
                $assetsCount = $assetService->countByPlace(\Auth::user()->place_id);
                $dataPieChart = $assetService->getByCategory(null,\Auth::user()->place_id);
                $dataContainerChart = $assetService->getBystatus(\Auth::user()->company_id,\Auth::user()->place_id);
                $reportLink = route('reports.pdfplacereport',[\Auth::user()->company_id, \Auth::user()->place_id]);
            }

        }

        if(isset($data['draw'])){

            if($request->session()->exists('companyReport') && $request->session()->get('companyReport') != ''){

                if($request->session()->exists('placeReport') && $request->session()->get('placeReport') != ''){

                    $datatable->setQueryType(ReportDatatable::QUERY_BY_PLACE);
                    $datatable->setIdQuery($request->session()->get('placeReport'));
                    $assetsCount = $assetService->countByPlace($request->session()->get('placeReport'));
                    $dataPieChart = $assetService->getByCategory(null,$request->session()->get('placeReport'));
                    $dataContainerChart = $assetService->getBystatus($request->session()->get('companyReport'),$request->session()->get('placeReport'));
                    $reportLink = route('reports.pdfplacereport',[$request->session()->get('companyReport'),$request->session()->get('placeReport')]);
                }
                else {

                    $datatable->setQueryType(ReportDatatable::QUERY_BY_COMPANY);
                    $datatable->setIdQuery($request->session()->get('companyReport'));
                    $assetsCount = $assetService->countByCompany($request->session()->get('companyReport'));
                    $dataPieChart = $assetService->getByCategory($request->session()->get('companyReport'));
                    $dataContainerChart = $assetService->getBystatus($request->session()->get('companyReport'));
                    $reportLink = route('reports.pdfcompanyreport', $request->session()->get('companyReport'));
                }
            }
            else{

                if(\Auth::user()->hasRole('admin')){

                    $datatable->setQueryType(ReportDatatable::GENERAL_QUERY);
                    $assetsCount = $assetService->generalCount();
                    $dataPieChart = $assetService->getByCategory();
                    $dataContainerChart = $assetService->getBystatus();
                    $reportLink = route('reports.pdfreport');
                }
                elseif(\Auth::user()->hasRole('chefe')){

                    $datatable->setQueryType(ReportDatatable::QUERY_BY_COMPANY);
                    $datatable->setIdQuery(\Auth::user()->company_id);
                    $assetsCount = $assetService->countByCompany(\Auth::user()->company_id);
                    $dataPieChart = $assetService->getByCategory(\Auth::user()->company_id);
                    $dataContainerChart = $assetService->getBystatus(\Auth::user()->company_id,\Auth::user()->place_id);
                    $reportLink = route('reports.pdfcompanyreport', \Auth::user()->company_id);
                }
                elseif(\Auth::user()->hasRole('gerente')){

                    $datatable->setQueryType(ReportDatatable::QUERY_BY_PLACE);
                    $datatable->setIdQuery(\Auth::user()->place_id);
                    $assetsCount = $assetService->countByPlace(\Auth::user()->place_id);
                    $dataPieChart = $assetService->getByCategory(null,\Auth::user()->place_id);
                    $dataContainerChart = $assetService->getBystatus(\Auth::user()->company_id,\Auth::user()->place_id);
                    $reportLink = route('reports.pdfplacereport',[\Auth::user()->company_id, \Auth::user()->place_id]);
                }
            }

            $request->session()->forget('placeReport');
            $request->session()->forget('companyReport');

        }

        \JavaScript::put([
            'dataPieChart' => json_encode($dataPieChart),
            'dataContainerChart' => json_encode($dataContainerChart),
        ]);

        $form = $this->form($this->formClass, [
            'method' => 'GET',
            'url' => '/reports',
            'id' => 'module_form',
            'model' => $data
        ]);

        $datatable->setAjaxSource(route('reports'));
        $datatable->addScope(new OwnableEntityScope(\Auth::user(), 'reports'));

        return $datatable = $datatable->render('reports::index', 
            compact(
                'assetsCount',
                'dataPieChart',
                'dataContainerChart',
                'form',
                'reportLink'
            )
        );

    }

    public function pdfReport($company_id = null,$place_id = null){

        $asset = new Asset();

        $assets = $asset->newQuery()
        ->leftJoin('status', 'assets.status_id', '=', 'status.id')
        ->leftJoin('categories', 'assets.category_id', '=', 'categories.id')
        ->leftJoin('areas', 'assets.area_id', '=', 'areas.id')
        ->select([
            'assets.id',
            'assets.asset_number',
            'assets.category_id',
            'assets.status_id',
            'assets.area_id',
            'areas.name as area_name',
            'status.name as status_name',
            'categories.name as category_name',
        ]);
        if($place_id != null){
            $assets = $assets->where('assets.place_id', $place_id);
        }
        elseif($company_id != null){
            $assets = $assets->where('assets.company_id', $company_id);
        }
        $assets = $assets->get();

        if($place_id != null){
            $place = Place::find($place_id);
            $fileName = trans('reports::reports.asset_report') . $place->identifier_name . '.pdf';
            $view = view('reports::reports.pdfReport', [
                'assets' => $assets,
                'place' => $place
            ]);
        }
        elseif($company_id != null){
            $company = Company::find($company_id);
            $fileName = trans('reports::reports.asset_report') . $company->name . '.pdf';
            $view = view('reports::reports.pdfReport', [
                'assets' => $assets,
                'company' => $company
            ]);
        }
        else{
            $fileName = trans('reports::reports.asset_general_report') . '.pdf';
            $view = view('reports::reports.pdfReport', [
                'assets' => $assets
            ]);
        }

        $pdf = PDF::loadHTML($view);

        return $pdf->download($fileName);

    }


}
