<?php

namespace Modules\Platform\User\Http\Requests;

use App\Http\Requests\Request;

/**
 * Class GroupUpdateRequest
 * @package Modules\Platform\User\Http\Requests
 */
class GroupUpdateRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => 'max:255|required|unique:groups,id,' . $this->get('id')
        ];
    }
}
