<?php

namespace Modules\Platform\Settings\ViewComposers;

use Illuminate\Support\Facades\Lang;
use Illuminate\View\View;
use Spatie\Menu\Html;
use Spatie\Menu\Link;
use Spatie\Menu\Menu;
use Spatie\Menu\ActiveUrlChecker;

/**
 * Class SettingsMenuComposer
 * @package Modules\Platform\Settings\ViewComposers
 */
class SettingsMenuComposer
{


    /**
     * Compose Settings Menu
     * @param View $view
     */
    public function compose(View $view)
    {
        $html  = '<ul class="m-menu__nav  m-menu__nav--dropdown-submenu-arrow ">';

        // General Settings

        $html .= '<li class="m-menu__section m-menu__section--first">
                <h4 class="m-menu__section-text">'. Lang::get('settings::settings.menu.general') . '</h4>
                <i class="m-menu__section-icon flaticon-more-v3"></i>
             </li>';

        $html .= $this->renderItem(route('settings.display'), Lang::get('settings::settings.menu.display'));
        $html .= $this->renderItem(route('settings.language.index'), trans('settings::settings.menu.language'));
        $html .= $this->renderItem(route('settings.timezone.index'), trans('settings::settings.menu.timezone'));
        $html .= $this->renderItem(route('settings.dateformat.index'), trans('settings::settings.menu.dateformat'));
        $html .= $this->renderItem(route('settings.timeformat.index'), trans('settings::settings.menu.timeformat'));
        $html .= $this->renderItem(route('settings.currency.index'), trans('settings::settings.menu.currency'));
        $html .= $this->renderItem(route('settings.tax.index'), trans('settings::settings.menu.tax'));
        $html .= $this->renderItem(route('settings.menu_manager.index'), trans('settings::settings.menu.menu_manager'));

        $html .= '<li class="m-menu__section">
                <h4 class="m-menu__section-text">'. trans('settings::settings.menu.user_and_access') . '</h4>
                <i class="m-menu__section-icon flaticon-more-v3"></i>
             </li>';

        $html .= $this->renderItem(route('settings.users.index'), trans('settings::settings.menu.users'));
        $html .= $this->renderItem(route('settings.roles.index'), trans('settings::settings.menu.roles'));
        $html .= $this->renderItem(route('settings.groups.index'), trans('settings::settings.menu.groups'));

        $html .= '<li class="m-menu__section">
                <h4 class="m-menu__section-text">'. trans('settings::settings.menu.others') . '</h4>
                <i class="m-menu__section-icon flaticon-more-v3"></i>
             </li>';

        $html .= $this->renderItem(route('settings.company_settings'), trans('settings::settings.menu.company'));
        $html .= $this->renderItem(route('settings.announcement'), trans('settings::settings.menu.announcement'));
        $html .= $this->renderItem(route('settings.outgoing_server'), trans('settings::settings.menu.outgoing_server'));



        $html .= '</ul>';

        $view->with('settingsMenu', $html);
    }

    private function renderItem($url, $label)
    {
        $requestUrl = \Request::path();
        $isActive = ActiveUrlChecker::check($url, $requestUrl);

        return '<li class="m-menu__item'. ( $isActive ? ' m-menu__item--active' : '' ) .'" aria-haspopup="true"  m-menu-link-redirect="1">
                <a  href="'. $url .'" class="m-menu__link ">
                <i class="m-menu__link-bullet m-menu__link-bullet--dot">
                    <span></span></i>
                    <span class="m-menu__link-text">'. $label .'</span>
                </a>
            </li>';
    }
}
