@extends('layouts.app')

@section('content')
    @include('settings::partial.menu')
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <div class="m-subheader ">
            <div class="d-flex align-items-center">
                <div class="mr-auto">
                    <h3 class="m-subheader__title m-subheader__title--separator">
                            <a href="{{ route('settings.menu_manager.create_element') }}" class="btn m-btn m-btn--gradient-from-success m-btn--gradient-to-accent float-right m-l-5">@lang('menumanager::menu_manager.add')</a>
                            @lang('menumanager::menu_manager.module')
                            <small>@lang('menumanager::menu_manager.module_description')</small>
                    </h3>
                </div>
            </div>
        </div>
        <!-- END: Subheader -->                      

        <div class="m-content">
            <div class="row clearfix">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    <b><i class="fa fa-info-circle" aria-hidden="true"></i> @lang('menumanager::menu_manager.help')</b> <br />
                    @lang('menumanager::menu_manager.additional_description') <br /><br />

                    <a target="_blank" href="/bap/pages/ui/icons.html"> @lang('menumanager::menu_manager.icon_ref')</a>
                </div>
            </div>

            <div class="row clearfix">
                <div class="col-lg-6">
                    <div class="m-portlet m-portlet--tab menu-item-container">
                        
                        <div class="m-portlet__head">
                            <div class="m-portlet__head-caption">
                                <div class="m-portlet__head-title">
                                    <span class="m-portlet__head-icon m--hide">
                                        <i class="la la-gear"></i>
                                    </span>
                                    <h3 class="m-portlet__head-text">
                                        @lang('menumanager::menu_manager.main_menu')
                                    </h3>
                                </div>
                            </div>
                        </div>

                        <div class="dd nestable-with-handle menu-item-manager">
                            <ol class="dd-list">
                                @foreach($mainMenu as $menu)
                                    @if($menu->parent_id == null )
                                        @include('menumanager::partial.menuItem',['menu'=>$menu])
                                    @endif
                                @endforeach
                            </ol>
                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="m-portlet m-portlet--tab menu-item-container">
                        {!! form($menuForm) !!}
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection

@push('css')
    <link href="{{ asset('bap/plugins/nestable/jquery-nestable.css') }}" rel="stylesheet" type="text/css">
@endpush
@push('scripts')
    <script src="{{ asset('bap/plugins/nestable/jquery.nestable.js')}}"></script>
    <script src="{!! Module::asset('menumanager:js/BAP_MenuManager.js') !!}"></script>

    {!! JsValidator::formRequest(\Modules\Platform\MenuManager\Http\Requests\SaveMenuElementRequest::class, '#save_menu_element_form') !!}
@endpush
