@extends('layouts.app')

@section('content')
     
    @if(\Auth::user()->hasRole('admin'))
        @include('settings::partial.menu')
    @endif

    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <div class="m-subheader ">
            <div class="d-flex align-items-center">
                <div class="mr-auto">

                </div>
            </div>
        </div>
        <!-- END: Subheader -->                      

        <div class="m-content">
            @include('flash::message')
            
             <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">

                <div class="m-portlet__head" style="">
                    <div class="m-portlet__head-progress">

                        <!-- here can place a progress bar-->
                    </div>
                    
                    <div class="m-portlet__head-wrapper">
                        <div class="m-portlet__head-caption">
                            <div class="m-portlet__head-title">
                                <span class="m-portlet__head-icon">
                                    <i class="@lang($language_file . '.entity_icon')"></i>
                                </span>

                                <h3 class="m-portlet__head-text">
                                    @lang($language_file.'.module') - @lang('core::core.crud.show')
                                    <small>@lang($language_file.'.module_description')</small>
                                </h3>

                            </div>
                        </div>

                        <div class="m-portlet__head-tools">
                            <a href="{{ route($routes['index']) }}" class="btn btn-secondary m-btn--icon m--margin-right-10" title="@lang('core::core.crud.back')">
                                <span>
                                    <i class="la la-arrow-left"></i>
                                    <span>@lang('core::core.crud.back')</span>
                                </span>
                            </a>
                             <div class="btn-group next-prev-btn-group m--margin-right-10" role="group">
                                @if($prev_record)
                                    <a href="{{ route($routes['show'],$prev_record) }}"
                                       title="@lang('core::core.crud.prev')"
                                       class="btn btn-metal m-btn m-btn--icon btn-crud btn-prev">@lang('core::core.crud.prev')</a>
                                @endif

                                @if($next_record)
                                    <a href="{{ route($routes['show'],$next_record) }}"
                                       title="@lang('core::core.crud.next')"
                                       class="btn btn-metal m-btn m-btn--icon btn-crud btn-next">@lang('core::core.crud.next')</a>
                                @endif
                            </div>
                            
                            {!! Form::open(['route' => [$routes['destroy'], $entity], 'method' => 'delete']) !!}

                            {!! Form::button(trans('core::core.crud.delete'), [ 'type' => 'submit', 'class' => 'btn m--margin-right-10 btn-outline-danger btn-edit btn-crud', 'onclick' => "return confirm($.i18n._('are_you_sure'))" ]) !!}

                            {!! Form::close() !!}
                            

                            <div class="btn-group">
                                <a href="{{ route($routes['edit'],$entity) }}"
                               class="btn btn-brand  m-btn btn-edit btn-crud">
                                    @lang($language_file.'.edit')
                                </a>

                                @if(isset($customShowButtons) && count($customShowButtons) > 0)
                                    <button type="button" class="btn btn-brand  dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        @foreach($customShowButtons as $btn)
                                        <a class="dropdown-item" 
                                            href="{{ isset($btn['href']) ? $btn['href'] : '#' }}"
                                            @foreach($btn['attr'] as $key => $value)
                                                {{$key}}="{{$value}}"
                                            @endforeach
                                            >
                                            {{ $btn['label'] }}
                                        </a>
                                        @endforeach
                                    
                                    </div>
                                @endif
                            </div>
                        </div>

                    </div>
                </div>

                <div class="m-portlet__body row">
                    @foreach($show_fields as $panelName => $panel)
                        {{ Html::section($language_file,$panelName) }}


                            @foreach($panel as $fieldName => $options)
                                {{
                                    Html::renderField($entity,$fieldName,$options,$language_file)
                                }}
                            @endforeach

                    @endforeach
                </div>
            </div>
        </div>
    </div>

    @foreach($includeViews as $v)
        @include($v)
    @endforeach

@endsection


@push('scripts')
    @foreach($jsFiles as $jsFile)
        <script src="{!! Module::asset($moduleName.':js/'.$jsFile) !!}"></script>
    @endforeach
@endpush


