
@extends('layouts.app')

@section('content')
    @if(\Auth::user()->hasPermissionTo('settings.access'))
        @include('settings::partial.menu')
    @endif
    <div class="m-grid__item m-grid__item--fluid m-wrapper">                               
        <!-- BEGIN: Subheader -->
        <div class="m-subheader ">
            <div class="d-flex align-items-center">
                <div class="mr-auto">

                </div>
            </div>
        </div>
        <!-- END: Subheader -->                      

        <div class="m-content">
            
            @include('flash::message')

             <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">

                <div class="m-portlet__head" style="">
                    <div class="m-portlet__head-progress">

                        <!-- here can place a progress bar-->
                    </div>
                    
                    <div class="m-portlet__head-wrapper">
                        <div class="m-portlet__head-caption">
                            <div class="m-portlet__head-title">

                                <span class="m-portlet__head-icon">
                                    <i class="@lang($language_file . '.entity_icon')"></i>
                                </span>

                                <h3 class="m-portlet__head-text">
                                    @lang($language_file.'.module')
                                    <small>@lang($language_file.'.module_description')</small>
                                </h3>

                            </div>
                        </div>

                        <div class="m-portlet__head-tools">
                             <a href="{{ route($routes['create']) }}" class="btn btn-brand  m-btn m-btn--icon m-btn--wide m-btn--md btn-create btn-crud">@lang('core::core.crud.create')</a>
                        </div>

                    </div>
                </div>

                <div class="m-portlet__body">
                        {!! $dataTable->table(['width' => '100%']) !!}
                </div>
            </div>
        </div>
    </div>

@endsection


@push('scripts')
    @foreach($jsFiles as $jsFile)
        <script src="{!! Module::asset($moduleName.':js/'.$jsFile) !!}"></script>
    @endforeach
@endpush

@push('scripts')
    {!! $dataTable->scripts() !!}
@endpush
