<?php

namespace Modules\Places\Http\Forms;

use Kris\LaravelFormBuilder\Form;

use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Helper\FormHelper;


class PlaceForm extends Form
{
    public function buildForm()
    {

        if (isset($this->model['relatedEntity']) && isset($this->model['place_id'])) {
            $this->model['company_id'] = Place::find($this->model['place_id'])['company_id'];
        }

        if(isset($this->model['company_id']) && $this->model['company_id'] != null && \Auth::user()->hasRole('admin')){

            $this->add('company_id', 'choice', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                'selected' => $this->model['company_id'],
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('places::places.form.company'),
            ]);
            $this->add('company', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => $this->model['company_id']
            ]);
        }
        else {
            if(\Auth::user()->hasRole('admin')){

                $this->add('company_id', 'choice', [
                    'choices' => Company::all()->pluck('name', 'id')->toArray(),
                    'attr' => ['class' => 'select2 pmd-select2 form-control'],
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('places::places.form.company'),
                ]);
            }
            else{

                $this->add('company_id', 'hidden', [
                    'attr' => ['name' => 'company_id' ],
                    'value' => \Auth::user()->company_id
                ]);
            }
        }
        $this->add('identifier_name', 'text', [
            'label' => trans('places::places.form.identifier_name'),
        ]);

        $this->add('city', 'text', [
            'label' => trans('places::places.form.city'),
        ]);

        $this->add('state', 'text', [
            'label' => trans('places::places.form.state'),
        ]);

        $this->add('street', 'text', [
            'label' => trans('places::places.form.street'),
        ]);

        $this->add('number', 'text', [
            'label' => trans('places::places.form.number'),
        ]);

        $this->add('neighborhood', 'text', [
            'label' => trans('places::places.form.neighborhood'),
        ]);

        $this->add('complement', 'text', [
            'label' => trans('places::places.form.complement'),
        ]);

        $this->add('postal_code', 'text', [
            'attr' => ['class' => 'form-control cep'],
            'label' => trans('places::places.form.postal_code'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('places::places.form.notes'),
        ]);

        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }

}