<?php

namespace Modules\Places\Http\Controllers\Tabs;

use Modules\Places\Entities\Place;
use Modules\Platform\User\Entities\User;
use Modules\Places\Datatables\Tabs\PlaceUsersDatatable;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;

/**
 * Class AccountsTicketsController
 * @package Modules\Places\Http\Controllers
 */
class PlaceUsersController extends ModuleCrudRelationController
{
    protected $datatable = PlaceUsersDatatable::class;

    protected $ownerModel = Place::class;

    protected $relationModel = User::class;

    protected $ownerModuleName = 'places';

    protected $relatedModuleName = 'users';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'users';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Place';
}
