<?php

namespace Modules\Places\Http\Controllers\Tabs;

use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Asset;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;
use Modules\Places\Datatables\Tabs\PlaceAssetsDatatable;

/**
 * Class AccountsTicketsController
 * @package Modules\Assets\Http\Controllers
 */ 
class PlaceAssetsController extends ModuleCrudRelationController
{
    protected $datatable = PlaceAssetsDatatable::class;

    protected $ownerModel = Place::class;

    protected $relationModel = Asset::class;

    protected $ownerModuleName = 'places';

    protected $relatedModuleName = 'assets';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'assets';

    protected $relationTableName = 'assets';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Place';
}
