<?php
namespace Modules\Places\Datatables\Tabs;

use Modules\Assets\Entities\Asset;
use Modules\Assets\Entities\Category;
use Modules\Assets\Entities\Status;
use Modules\Places\Entities\Place;
use Modules\Collaborators\Entities\Area;
use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Datatable\RelationDataTable;
use Modules\Platform\Core\Helper\DataTableHelper;
use Yajra\DataTables\EloquentDataTable;

/**
 * Class CampaignsContactsDatatable
 * @package Modules\Campaigns\Datatables\Tabs
 */
class PlaceAssetsDatatable extends RelationDataTable
{
    const SHOW_URL_ROUTE = 'assets.assets.show';
    const EDIT_URL_ROUTE = 'assets.assets.edit';
    const REMOVE_URL_ROUTE = 'assets.assets.destroy';

    protected $unlinkRoute = 'places.assets.unlink';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE, 'places_');

        return $dataTable;
    }


    /**
     * Get query source of dataTable.
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Asset $model)
    {
        $query = $model->newQuery()
        ->leftJoin('categories', 'assets.category_id', '=', 'categories.id')
        ->leftJoin('status', 'assets.status_id', '=', 'status.id')
        ->leftJoin('areas', 'assets.area_id', '=', 'areas.id')
        ->leftJoin('places', 'assets.place_id', '=', 'places.id')
        ->select([
            'assets.id',
            'assets.company_id',
            'assets.status_id',
            'assets.area_id',
            'assets.category_id',
            'assets.place_id',
            'assets.asset_number',
            'assets.serial_number_1',
            'assets.serial_number_2',
            'assets.item',
            'categories.name as category_name',
            'assets.model',
            'areas.name as area_name',
            'assets.responsible',
            'places.identifier_name as place_name',
            'assets.purchase_date',
            'assets.age',
            'assets.purchase_value',
            'assets.conservation_state',
            'assets.useful_life',
            'status.name as status_name',
            'assets.current_value',
        ]);

        return $query;
    }


    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {

        $currentColumn = 0;
        $columnFilters = [];

        $areas = [];
        $data_areas = [];

        $areas = Area::all()->toArray();
    
        foreach ($areas as $area){
            $data_areas[] = [
                'value' => $area['id'],
                'label' => $area['name'],
            ];
        }

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'select',
            'select_type' => 'select2',
            'select_type_options' => [
                'theme' => "bootstrap",
                'width' => '100%'
            ],
            'data' => $data_areas                    
        ];


        $categories = [];
        $data_categories = [];

        $categories = Category::all()->toArray();
        
        foreach ($categories as $category){
            $data_categories[] = [
                'value' => $category['id'],
                'label' => $category['name'],
            ];
        }

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'select',
            'select_type' => 'select2',
            'select_type_options' => [
                'theme' => "bootstrap",
                'width' => '100%'
            ],
            'data' => $data_categories                    
        ];

        $status = [];
        $data_status = [];

        $status = Status::all()->toArray();

        foreach ($status as $stat){
            $data_status[] = [
                'value' => $stat['id'],
                'label' => $stat['name'],
            ];
        }

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'select',
            'select_type' => 'select2',
            'select_type_options' => [
                'theme' => "bootstrap",
                'width' => '100%'
            ],
            'data' => $data_status                    
        ];

        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];
        $columnFilters[] = [
            'column_number' => $currentColumn++,
            'filter_type' => 'text'
        ];

        return $this->builder()
            ->columns($this->getColumns())
            ->setTableId('PlaceAssetsDatatable' . $this->tableSuffix)
            ->minifiedAjax(route($this->route, ['entityId' => $this->entityId]))

            ->setTableAttribute('class', 'table responsive table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",

                'stateSave' => true,
                'columnFilters' => $columnFilters,
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true

            ]);
    }

    /**
     * @return array
     */
    protected function getColumns()
    {

        $unlink = [
            'unlink' => [
                'data' => 'unlink',
                'title' => '',
                'data_type' => 'unlink',
                'orderable' => false,
                'searchable' => false,

            ]
        ];

        $check_selection = [
            'check_select' => [
                'data' => 'check_select',
                'title' => '',
                'data_type' => 'check_select',
                'orderable' => false,
                'searchable' => false,
            ]
        ];

       $data = [];

        $data += [

            'area_name' => [
                'name' => 'area_id',
                'data' => 'area_name',
                'title' => trans('assets::assets.table.area_name'),
                'data_type' => 'text'
            ],

            'category_name' => [
                'name' => 'category_id',
                'data' => 'category_name',
                'title' => trans('assets::assets.table.category_name'),
                'data_type' => 'text'
            ],

            'status_name' => [
                'name' => 'status_name',
                'data' => 'status_name',
                'title' => trans('assets::assets.table.status_id'),
                'data_type' => 'text'
            ],
            'asset_number' => [
                'data' => 'asset_number',
                'title' => trans('assets::assets.table.asset_number'),
                'data_type' => 'text'
            ],
            'item' => [
                'data' => 'item',
                'title' => trans('assets::assets.table.item'),
                'data_type' => 'text',
            ],

            'actions' => ['title' => trans('core::core.table.actions'), 'data_type' => 'actions', 'orderable' => false],
        ];
        
        return $data;

    }
}
