<?php

namespace Modules\Companies\Http\Controllers\Tabs;

use Modules\Companies\Entities\Company;
use Modules\Places\Entities\Place;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;
use Modules\Companies\Datatables\Tabs\CompanyPlacesDatatable;

/**
 * Class AccountsTicketsController
 * @package Modules\Places\Http\Controllers
 */
class CompanyPlacesController extends ModuleCrudRelationController
{
    protected $datatable = CompanyPlacesDatatable::class;

    protected $ownerModel = Company::class;

    protected $relationModel = Place::class;

    protected $ownerModuleName = 'companies';

    protected $relatedModuleName = 'places';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'places';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Company';
}
