<?php

namespace Modules\Companies\Entities;

use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Status;
use Modules\Clients\Entities\Client;
use Modules\Assets\Entities\Category;
use Illuminate\Database\Eloquent\Model;
use Modules\Collaborators\Entities\Area;
use Modules\Platform\User\Entities\User;
use Modules\Suppliers\Entities\Supplier;
use Modules\Collaborators\Entities\Collaborator;

/**
 * @property int $id
 * @property string $name
 * @property string $notes
 * @property string $created_at
 * @property string $updated_at
 * @property string $deleted_at
 * @property string $company_tax_number
 * @property string $email
 * @property string $phone
 * @property string $mobile
 * @property string $city
 * @property string $state
 * @property string $street
 * @property string $number
 * @property string $neighborhood
 * @property string $complement
 * @property string $postal_code
 * @property Area[] $areas
 * @property Asset[] $assets
 * @property AssetsStatusLog[] $assetsStatusLogs
 * @property Category[] $categories
 * @property Client[] $clients
 * @property Collaborator[] $collaborators
 * @property Place[] $places
 * @property Status[] $statuses
 * @property Supplier[] $suppliers
 * @property User[] $users
 */
class Company extends Model
{
    /**
     * @var array
     */
    protected $fillable = ['name', 'notes', 'created_at', 'updated_at', 'deleted_at', 'company_tax_number', 'email', 'phone', 'mobile', 'city', 'state', 'street', 'number', 'neighborhood', 'complement', 'postal_code'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function areas()
    {
        return $this->hasMany(Area::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function assets()
    {
        return $this->hasMany(Asset::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function categories()
    {
        return $this->hasMany(Category::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function clients()
    {
        return $this->hasMany(App\Client::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function collaborators()
    {
        return $this->hasMany(Collaborator::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function places()
    {
        return $this->hasMany(Place::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function status()
    {
        return $this->belongsToMany(Status::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function suppliers()
    {
        return $this->hasMany(Supplier::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function users()
    {
        return $this->hasMany(User::class);
    }
}
