<?php

namespace Modules\Companies\Datatables;


use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Datatable\PlatformDataTable;
use Modules\Platform\Core\Helper\DataTableHelper;
use Yajra\DataTables\EloquentDataTable;

class CompanyDatatable extends PlatformDataTable
{

    const SHOW_URL_ROUTE = 'companies.companies.show';
    const EDIT_URL_ROUTE = 'companies.companies.edit';
    const REMOVE_URL_ROUTE = 'companies.companies.destroy';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE);

        return $dataTable;
    }

    /**
     * Get query source of dataTable.
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Company $model)
    {
        return $model->newQuery()
        ->select([
            'companies.id',
            'companies.name',
            'companies.email',
            'companies.company_tax_number',
            'companies.email',
            'companies.state',
            'companies.city',
        ]);
    }

    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        //TODO Implement multiselect

        return $this->builder()
            ->columns($this->getColumns())

            ->setTableAttribute('class', 'table table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",

                'stateSave' => true,
                'columnFilters' => [
                    [
                        'column_number' => 0,
                        'filter_type' => 'text'
                    ],
                    [
                        'column_number' => 1,
                        'filter_type' => 'text',

                    ],
                    [
                        'column_number' => 2,
                        'filter_type' => 'text',
                    ],
                    [
                        'column_number' => 3,
                        'filter_type' => 'text',
                    ],
                    [
                        'column_number' => 4,
                        'filter_type' => 'text',
                    ],
                    [
                        'column_number' => 5,
                        'filter_type' => 'text',
                    ],
                ],
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true

            ]);
    }

    /**
     * @return array
     */
    protected function getColumns()
    {
        return
            [
                'name' => [
                    'data' => 'name',
                    'title' => trans('companies::companies.table.name'),
                    'data_type' => 'text'
                ],
                'email' => [
                    'data' => 'email',
                    'title' => trans('companies::companies.table.email'),
                    'data_type' => 'text'
                ],
                'company_tax_number' => [
                    'data' => 'company_tax_number',
                    'title' => trans('companies::companies.table.company_tax_number'),
                    'data_type' => 'text'
                ],
                'email' => [
                    'data' => 'email',
                    'title' => trans('companies::companies.table.email'),
                    'data_type' => 'text'
                ],
                'state' => [
                    'data' => 'state',
                    'title' => trans('companies::companies.table.state'),
                    'data_type' => 'text'
                ],
                'city' => [
                    'data' => 'city',
                    'title' => trans('companies::companies.table.city'),
                    'data_type' => 'text'
                ],

                'actions' => ['title' => trans('core::core.table.actions'), 'data_type' => 'actions', 'orderable' => false],
            ];

    }

}
