<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddCompanyInformation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up() {

        Schema::table('companies', function (Blueprint $table) {

            $table->string('company_tax_number')->nullable();
            
            $table->string('email')->nullable();

            $table->string('phone')->nullable();

            $table->string('mobile')->nullable();

            $table->string('city')->nullable();

            $table->string('state')->nullable();

            $table->string('street')->nullable();

            $table->string('number')->nullable();

            $table->string('neighborhood')->nullable();

            $table->string('complement')->nullable();

            $table->string('postal_code')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('companies', function (Blueprint $table) {

            $table->dropColumn('company_tax_number');

            $table->dropColumn('email');

            $table->dropColumn('phone');

            $table->dropColumn('mobile');

            $table->dropColumn('city');

            $table->dropColumn('state');

            $table->dropColumn('street');

            $table->dropColumn('number');

            $table->dropColumn('neighborhood');

            $table->dropColumn('complement');

            $table->dropColumn('postal_code');

        });
    }
}
