<?php

namespace Modules\Collaborators\Http\Forms;

use Kris\LaravelFormBuilder\Form;

use Modules\Places\Entities\Place;
use Modules\Companies\Entities\Company;
use Modules\Collaborators\Entities\Area;
use Modules\Platform\Core\Helper\FormHelper;

class CollaboratorForm extends Form
{
    public function buildForm()
    {

        if(\Auth::user()->hasRole('admin')){

            if(isset($this->model['place_id']) && $this->model['place_id'] != null){

                $this->add('company_id', 'choice', [
                    'choices' => Company::all()->pluck('name', 'id')->toArray(),
                    'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                    'selected' => Place::find($this->model['place_id'])['company_id'],
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('collaborators::collaborators.form.company'),
                ]);
                $this->add('company', 'hidden', [
                    'attr' => ['name' => 'company_id' ],
                    'value' => Place::find($this->model['place_id'])['company_id'],
                ]);
            }
            elseif(isset($this->model['company_id']) && $this->model['company_id'] != null){

                $this->add('company_id', 'choice', [
                    'choices' => Company::all()->pluck('name', 'id')->toArray(),
                    'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                    'selected' => $this->model['company_id'],
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('collaborators::collaborators.form.company'),
                ]);
                $this->add('company', 'hidden', [
                    'attr' => ['name' => 'company_id' ],
                    'value' => $this->model['company_id'],
                ]);
            }
            else{
                $this->add('company_id', 'choice', [
                    'choices' => Company::all()->pluck('name', 'id')->toArray(),
                    'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('collaborators::collaborators.form.company'),
                ]);
            }
        }
        else{

            $this->add('company_id', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => \Auth::user()->company_id
            ]);
        }

        if(! \Auth::user()->hasRole('gerente')){

            if(isset($this->model['relatedEntity']) && isset($this->model['place_id']) && $this->model['place_id'] != null){

                $this->add('place_id', 'choice', [
                    'choices' => Place::all()->pluck('identifier_name', 'id')->toArray(),
                    'attr' => ['class' => 'select2 pmd-select2 form-control', 'disabled' => 'true'],
                    'selected' => $this->model['place_id'],
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('collaborators::collaborators.form.place'),
                ]);
                $this->add('place', 'hidden', [
                    'attr' => ['name' => 'place_id' ],
                    'value' => $this->model['place_id']
                ]);

            }
            else{
                $places = [];
                if(isset($this->model['company_id']) && $this->model['company_id'] != null){
                    $places = Place::where('company_id', $this->model['company_id'])->pluck('identifier_name', 'id')->toArray();
                }
                elseif( \Auth::user()->hasRole('admin')){
                    $places = [];
                }
                else{
                    $places = Place::where('company_id', \Auth::user()->company_id)->pluck('identifier_name', 'id')->toArray();
                }

                $this->add('place_id', 'choice', [
                    'choices' => $places,
                    'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'place_select'],
                    'selected' => isset($this->model->place_id) ? $this->model->place_id : '' ,
                    'selected' => isset($this->model['place_id']) ? $this->model['place_id'] : '' ,
                    'expanded' => false,
                    'empty_value' => trans('core::core.empty_select'),
                    'label' => trans('collaborators::collaborators.form.place'),
                ]);
            }
        }
        else{

            $this->add('place_id', 'hidden', [
                'attr' => ['name' => 'place_id' ],
                'value' => \Auth::user()->place_id
            ]);
        }

        $areas = Area::pluck('name', 'id')->toArray();
        
        $this->add('area_id', 'choice', [
            'choices' => $areas,
            'attr' => ['class' => 'select2 pmd-select2 form-control', 'id' => 'area_select'],
            'selected' => isset($this->model->area_id) ? $this->model->area_id : '' ,
            'expanded' => false,
            'empty_value' => trans('core::core.empty_select'),
            'label' => trans('collaborators::collaborators.form.area'),
        ]);

        $this->add('name', 'text', [
            'label' => trans('collaborators::collaborators.form.name'),
        ]);

        $this->add('person_tax_number', 'text', [
            'attr' => ['class' => 'form-control cpf'],
            'label' => trans('collaborators::collaborators.form.person_tax_number'),
        ]);

        $this->add('email', 'text', [
            'label' => trans('collaborators::collaborators.form.email'),
        ]);

        $this->add('birthday', 'date', [
            'label' => trans('collaborators::collaborators.form.birthday'),
        ]);

        $this->add('phone', 'text', [
            'attr' => ['class' => 'form-control phone'],
            'label' => trans('collaborators::collaborators.form.phone'),
        ]);

        $this->add('mobile', 'text', [
            'attr' => ['class' => 'form-control mobile'],
            'label' => trans('collaborators::collaborators.form.mobile'),
        ]);

        $this->add('city', 'text', [
            'label' => trans('collaborators::collaborators.form.city'),
        ]);

        $this->add('state', 'text', [
            'label' => trans('collaborators::collaborators.form.state'),
        ]);

        $this->add('street', 'text', [
            'label' => trans('collaborators::collaborators.form.street'),
        ]);

        $this->add('number', 'text', [
            'label' => trans('collaborators::collaborators.form.number'),
        ]);

        $this->add('neighborhood', 'text', [
            'label' => trans('collaborators::collaborators.form.neighborhood'),
        ]);

        $this->add('complement', 'text', [
            'label' => trans('collaborators::collaborators.form.complement'),
        ]);

        $this->add('postal_code', 'text', [
            'attr' => ['class' => 'form-control cep'],            
            'label' => trans('collaborators::collaborators.form.postal_code'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('collaborators::collaborators.form.notes'),
        ]);

        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }

}