<?php

namespace Modules\Collaborators\Entities;

use Carbon\Carbon;
use Modules\Assets\Entities\Asset;
use Modules\Places\Entities\Place;
use Cog\Contracts\Ownership\Ownable;
use Illuminate\Database\Eloquent\Model;
use Modules\Companies\Entities\Company;
use Modules\Collaborators\Entities\Area;
use Bnb\Laravel\Attachments\HasAttachment;
use Spatie\Activitylog\Traits\LogsActivity;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Platform\Core\Traits\Commentable;
use Cog\Laravel\Ownership\Traits\HasMorphOwner;
use Modules\Platform\Core\Helper\ActivityLogHelper;

class Collaborator extends Model 
{

    use SoftDeletes;

    const CREATED_AT = 'created_at';
    const UPDATED_AT = 'updated_at';
    /**
     * Validation rules
     *
     * @var array
     */
    public static $rules = [

    ];
    public $table = 'collaborators';

    public $fillable = [
        'email',
        'name',
        'person_tax_number',
        'birthday',
        'email',
        'phone',
        'mobile',
        'city',
        'state',
        'street',
        'number',
        'neighborhood',
        'complement',
        'postal_code',
        'notes',
        'company_id',
        'place_id',
    ];

    protected $dates = ['deleted_at', 'created_at', 'updated_at'];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function place()
    {
        return $this->belongsTo(Place::class);
    }

    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function assets()
    {
        return $this->hasMany(Asset::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function area()
    {
        return $this->belongsTo(Area::class);
    }

}