<?php

namespace Modules\Clients\Http\Forms;

use Kris\LaravelFormBuilder\Form;
use Modules\Places\Entities\Place;
use Modules\Companies\Entities\Company;
use Modules\Platform\Core\Helper\FormHelper;


class ClientForm extends Form
{
    public function buildForm()
    {


        if(\Auth::user()->hasRole('admin')){
        
            $this->add('company_id', 'choice', [
                'choices' => Company::all()->pluck('name', 'id')->toArray(),
                'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'company_select'],
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('clients::clients.form.company'),
            ]);
        }
        else{

            $this->add('company_id', 'hidden', [
                'attr' => ['name' => 'company_id' ],
                'value' => \Auth::user()->company_id
            ]);
        }

        if(! \Auth::user()->hasRole('gerente')){
        
            $places = [];
            if( \Auth::user()->hasRole('admin')){
                $places = [];
            }
            else{
                $places = Place::where('company_id', \Auth::user()->company_id)->pluck('identifier_name', 'id')->toArray();
            }

            $this->add('place_id', 'choice', [
                'choices' => $places,
                'attr'     => ['class' => 'select2 pmd-select2 form-control', 'id' => 'place_select'],
                'selected' => $this->model ? $this->model->place_id : '' ,
                'expanded' => false,
                'empty_value' => trans('core::core.empty_select'),
                'label' => trans('user::users.form.place'),
            ]);
        }

        else{

            $this->add('place_id', 'hidden', [
                'attr' => ['name' => 'place_id' ],
                'value' => \Auth::user()->place_id
            ]);
        }
 
        $this->add('email', 'text', [
            'label' => trans('clients::clients.form.email'),
        ]);

        $this->add('person_type', 'choice', [
            'choices' => ['Pessoa Física' => 'Pessoa Física', 'Pessoa Jurídica' => 'Pessoa Jurídica'],
            'label' => trans('clients::clients.form.person_type'),
            'empty_value' => trans('core::core.empty_select'),
        ]);

        $this->add('person_tax_number-company_tax_number', 'text', [
            'attr' => ['class' => 'form-control'],
            'label' => trans('clients::clients.form.person_tax_number-company_tax_number'),
        ]);

        $this->add('fantasy_name', 'text', [
            'label' => trans('clients::clients.form.fantasy_name'),
        ]);

        $this->add('phone', 'text', [
            'attr' => ['class' => 'form-control phone'],
            'label' => trans('clients::clients.form.phone'),
        ]);

        $this->add('mobile', 'text', [
            'attr' => ['class' => 'form-control mobile'],
            'label' => trans('clients::clients.form.mobile'),
        ]);

        $this->add('city', 'text', [
            'label' => trans('clients::clients.form.city'),
        ]);

        $this->add('state', 'text', [
            'label' => trans('clients::clients.form.state'),
        ]);

        $this->add('street', 'text', [
            'label' => trans('clients::clients.form.street'),
        ]);

        $this->add('number', 'text', [
            'label' => trans('clients::clients.form.number'),
        ]);

        $this->add('neighborhood', 'text', [
            'label' => trans('clients::clients.form.neighborhood'),
        ]);

        $this->add('complement', 'text', [
            'label' => trans('clients::clients.form.complement'),
        ]);

        $this->add('postal_code', 'text', [
            'attr' => ['class' => 'form-control cep'],
            'label' => trans('clients::clients.form.postal_code'),
        ]);

        $this->add('notes', 'textarea', [
            'label' => trans('clients::clients.form.notes'),
        ]);

        $this->add('submit', 'submit', [
            'label' => trans('core::core.form.save'),
            'attr' => ['class' => 'btn btn-primary m-t-15 waves-effect']
        ]);

    }

}