<?php

Route::group(['middleware' => ['web','permission:assets.browse'], 'as'=>'assets.', 'namespace' => 'Modules\Assets\Http\Controllers'], function()
{
    Route::get('/',function(){
       return redirect()->route('assets.assets.index');
    });

    // Assets Routes
    Route::get('assets/maintenances-selection/{entityId}', ['as'=>'maintenances.selection','uses'=> 'Tabs\AssetMaintenancesController@selection']);
    Route::get('assets/maintenances-linked/{entityId}', ['as'=>'maintenances.linked','uses'=> 'Tabs\AssetMaintenancesController@linked']);
    Route::post('assets/maintenances-unlink', ['as'=>'maintenances.unlink','uses'=> 'Tabs\AssetMaintenancesController@unlink']);
    Route::post('assets/maintenances-link', ['as'=>'maintenances.link','uses'=> 'Tabs\AssetMaintenancesController@link']);
    
    Route::group(['middleware' => ['web','permission:assets.settings']], function(){

        Route::resource('status','Settings\StatusController');
        Route::resource('categories','Settings\CategoriesController');

    });

    Route::resource('assets', 'AssetsController');
});
