<?php

namespace Modules\Assets\Http\Requests;

use App\Http\Requests\Request;
use Illuminate\Validation\Rule;
/**
 * Class AssetsRequest
 * @package Modules\Assets\Http\Requests
 */
class AssetsRequest extends Request
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        $place_id = $this->request->get('place_id');

        return [
            'place_id' => 'required',
            'area_id' => 'required',
            'image_path' => 'mimes:jpeg,jpg,png',
            'company_id' => 'required',
            'serial_number_1' => 'required|unique:assets,serial_number_1,NULL,id,place_id,' . $place_id,
            'serial_number_2' => 'required|unique:assets,serial_number_2,NULL,id,place_id,' . $place_id,
            'item' => 'unique:assets,item,NULL,id,place_id,' . $place_id,
        ];
    }

    public function attributes() {
        return [
            'name' => trans('companies::companies.form.name'),
            'serial_number_1' => trans('assets::assets.form.serial_number_1'),
            'status' => trans('assets::assets.form.status'),
            'category' => trans('assets::assets.form.category'),
            'item' => trans('assets::assets.form.item'),
            'serial_number_2' => trans('assets::assets.form.serial_number_2'),
            'place_id' => trans('places::places.module'),
            'company_id' => trans('companies::companies.module'),
        ];
    }

}