<?php

namespace Modules\Assets\Http\Controllers\Tabs;

use Modules\Companies\Entities\Company;
use Modules\Maintenances\Entities\Maintenance;
use Modules\Assets\Entities\Asset;
use Modules\Platform\Core\Datatable\Scope\BasicRelationScope;
use Modules\Platform\Core\Http\Controllers\ModuleCrudRelationController;
use Modules\Assets\Datatables\Tabs\AssetMaintenancesDatatable;

/**
 * Class AccountsTicketsController
 * @package Modules\Assets\Http\Controllers
 */
class AssetMaintenancesController extends ModuleCrudRelationController
{
    protected $datatable = AssetMaintenancesDatatable::class;

    protected $ownerModel = Asset::class;

    protected $relationModel = Maintenance::class;

    protected $ownerModuleName = 'assets';

    protected $relatedModuleName = 'maintenances';

    protected $scopeLinked = BasicRelationScope::class;

    protected $modelRelationName = 'maintenances';

    protected $relationTableName = 'maintenances';

    protected $relationType = self::RT_ONE_TO_MANY;

    protected $belongsToName = 'Asset';
}
