<?php

namespace Modules\Assets\Http\Controllers\Settings;

use Illuminate\Http\Request;
use Modules\Assets\Entities\Category;
use Modules\Assets\Http\Forms\CategoryForm;
use Modules\Assets\Datatables\Settings\CategoriesDatatable;
use Modules\Platform\Core\Http\Requests\NameDictionaryRequest;
use Modules\Platform\Core\Http\Controllers\ModuleCrudController;
 
class CategoriesController extends ModuleCrudController
{
 
    protected $datatable = CategoriesDatatable::class;
    protected $formClass = CategoryForm::class; 
    protected $storeRequest = NameDictionaryRequest::class;
    protected $updateRequest = NameDictionaryRequest::class;
    protected $entityClass = Category::class;

    protected $moduleName = 'assets';

    protected $settingName = 'categories';

    protected $settingsBackRoute = 'assets.assets.index';

    protected $jsFiles = [
        'BAP_Categories.js',
    ];    
    
    protected $showFields = [
        'details' => [
            'name' => ['type' => 'text'],
            'notes' => ['type' => 'text'],
        ],
        'special_fields' => [
            'special_field_1' => ['type' => 'text'],
        ]
    ];

    protected $languageFile = 'assets::assets.categories';

    protected $routes = [
        'index' => 'assets.categories.index',
        'create' => 'assets.categories.create',
        'show' => 'assets.categories.show',
        'edit' => 'assets.categories.edit',
        'store' => 'assets.categories.store',
        'destroy' => 'assets.categories.destroy',
        'update' => 'assets.categories.update'
    ];

    public function __construct()
    {
        parent::__construct();
    } 

    /**
     * Overwritten function for handle special fields
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function store()
    {

        $request = \App::make(Request::class);

        $input = $request->all();

        foreach($input as $key => $value){
            if($value === ''){
                unset($input[$key]);
            }
        }

        $input['special_fields'] = '';

        $currentSpecialField = 1;

        while( isset($input['special_field_'.$currentSpecialField]) ) {
            if( $input['special_field_'.$currentSpecialField] === '' ) {
                continue;
            }

            $input['special_fields'] .= $input['special_field_'.$currentSpecialField].';;';
            ++$currentSpecialField;
        }

        $entity = \App::make(Category::class)->create($input);

        flash(trans($this->languageFile . '.created'))->success();

        return redirect(route($this->routes['index']));
    }

    /**
     * Overwritten function for handle special fields
     *
     * @param $identifier
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function show($identifier)
    {
        if ($this->permissions['browse'] != '' && !\Auth::user()->hasPermissionTo($this->permissions['browse'])) {
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $repository = $this->getRepository();

        $entity = $repository->find($identifier);

        $this->entity = $entity;

        if (empty($entity)) {
            flash(trans('core::core.entity.entity_not_found'))->error();
            return redirect(route($this->routes['index']));
        }

        if ($this->blockEntityOwnableAccess()) {
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $this->entityIdentifier = $entity->id;

        $showView = $this->views['show'];

        $this->entity = $entity;
        $qtdSpecialFields = 1;

        unset($this->showFields['special_fields']['special_field_1']);
        $this->showFields['special_fields'] = [];

        $o =  (object) $entity;

        foreach( explode(';;',$entity->special_fields) as $specialField ) {

            if( $specialField === '' ) {
                continue;
            }

            $this->showFields['special_fields']['special_field_'.$qtdSpecialFields] = ['type' => 'text', 'label' => 'Nome do campo especial '.$qtdSpecialFields];
            $o->{'special_field_'.$qtdSpecialFields} = $specialField;
            $qtdSpecialFields++;
        }

        $view = view($showView);
        $view->with('entity', $o);
        $view->with('show_fields', $this->showFields);
        $view->with('show_fileds_count', count($this->showFields));

        $view->with('next_record', $repository->next($entity));
        $view->with('prev_record', $repository->prev($entity));
        $view->with('disableNextPrev', $this->disableNextPrev);

        $this->setupCustomButtons();
        $this->setupActionButtons();
        $view->with('customShowButtons', $this->customShowButtons);
        $view->with('actionButtons', $this->actionButtons);
        $view->with('commentableExtension', false);
        $view->with('actityLogDatatable', null);
        $view->with('attachmentsExtension', false);
        $view->with('entityIdentifier', $this->entityIdentifier);


        $view->with('hasExtensions', false);

        $view->with('relationTabs', $this->setupRelationTabs($entity));

        $view->with('baseIcons', $this->baseIcons);

        /*
         * Extensions
         */
        if (in_array(self::COMMENTS_EXTENSION, class_uses($this->entity))) {
            $view->with('commentableExtension', true);
            $view->with('hasExtensions', true);
        }
        if (in_array(self::ACTIVITY_LOG_EXTENSION, class_uses($this->entity))) {
            $activityLogDataTable = \App::make(ActivityLogDataTable::class);
            $activityLogDataTable->setEntityData(get_class($entity), $entity->id);
            $view->with('actityLogDatatable', $activityLogDataTable->html());
            $view->with('hasExtensions', true);
        }
        if (in_array(self::ATTACHMENT_EXTENSION, class_uses($this->entity))) {
            $view->with('attachmentsExtension', true);
            $view->with('hasExtensions', true);
        }

        return $view;
    }

    /**
     * Overwritten function for handle special fields
     *
     * @param $identifier
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     */
    public function update($identifier)
    {
        if ($this->permissions['update'] != '' && !\Auth::user()->hasPermissionTo($this->permissions['update'])) {
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $repository = $this->getRepository();

        $entity = $repository->find($identifier);

        $this->entity = $entity;

        if (empty($entity)) {
            flash(trans('core::core.entity.entity_not_found'))->error();

            return redirect(route($this->routes['index']));
        }

        if ($this->blockEntityOwnableAccess()) {
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $request = \App::make(Request::class);

        $input = $request->all();

        $input['special_fields'] = '';

        $currentSpecialField = 1;

        while(isset($input['special_field_'.$currentSpecialField])) {
            if($input['special_field_'.$currentSpecialField] === ''){
                unset($input['special_field_'.$currentSpecialField]);
                continue;
            }

            $input['special_fields'] .= $input['special_field_'.$currentSpecialField].';;';
            unset($input['special_field_'.$currentSpecialField]);
            ++$currentSpecialField;
        }

        $repository = $this->getRepository();

        $entity->update($input);
        $this->entity = $entity;

        flash(trans('assets.assets.categories.updated'))->success();

        return redirect(route($this->routes['show'], $entity));
    }

    /**
     * Overwritten function for handle special fields
     *
     * @param $identifier
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector|\Illuminate\View\View
     */
    public function edit($identifier)
    {
        if ($this->permissions['update'] != '' && !\Auth::user()->hasPermissionTo($this->permissions['update'])) {
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $repository = $this->getRepository();

        $entity = $repository->find($identifier);

        $this->entity = $entity;

        if (empty($entity)) {
            flash(trans('core::core.entity.entity_not_found'))->error();

            return redirect(route($this->routes['index']));
        }

        if ($this->blockEntityOwnableAccess()) {
            flash(trans('core::core.you_dont_have_access'))->error();
            return redirect()->route($this->routes['index']);
        }

        $updateView = $this->views['edit'];

        $this->entity = $entity;

        if($entity->special_fields != ''){
            $qtdSpecialFields = 1;

            unset($this->showFields['special_fields']['special_fields']);
            $this->showFields['special_fields'] = [];

            $obj =  (object) $entity;

            foreach(explode(';;',$entity->special_fields) as $special_field){

                if($special_field === ''){
                    continue;
                }

                $this->showFields['special_fields']['special_field_'.$qtdSpecialFields] = ['type' => 'text', 'label' => 'Nome do campo especial '.$qtdSpecialFields];
                $obj->{'special_field_'.$qtdSpecialFields} = $special_field;
                $qtdSpecialFields++;
            }
        }

        $updateForm = $this->form($this->formClass, [
            'method' => 'PATCH',
            'url' => route($this->routes['update'], $entity),
            'id' => 'module_form',
            'class' => 'row  justify-content-start',
            'model' => ($entity->special_fields != '') ? $obj : $entity,
        ]);

        $view = view($updateView);
        $view->with('form_request', $this->storeRequest);
        $view->with('entity', $entity);
        $view->with('show_fields', $this->showFields);
        $view->with('sectionButtons', $this->sectionButtons);

        $view->with('form', $updateForm);

        return $view;
    }
    
    
}
