<?php
namespace Modules\Assets\Datatables\Tabs;

use Modules\Assets\Entities\Asset;
use Modules\Companies\Entities\Company;
use Modules\Assets\Entities\Category;
use Modules\Assets\Entities\Status;
use Modules\Places\Entities\Place;
use Modules\Maintenances\Entities\Maintenance;
use Modules\Platform\Core\Datatable\RelationDataTable;
use Modules\Platform\Core\Helper\DataTableHelper;
use Yajra\DataTables\EloquentDataTable;

/**
 * Class CampaignsContactsDatatable
 * @package Modules\Campaigns\Datatables\Tabs
 */
class AssetMaintenancesDatatable extends RelationDataTable
{
    const SHOW_URL_ROUTE = 'maintenances.maintenances.show';
    const EDIT_URL_ROUTE = 'maintenances.maintenances.edit';
    const REMOVE_URL_ROUTE = 'maintenances.maintenances.destroy';

    protected $unlinkRoute = 'assets.maintenances.unlink';

    /**
     * Build DataTable class.
     *
     * @param mixed $query Results from query() method.
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable($query)
    {
        $dataTable = new EloquentDataTable($query);

        $this->applyLinks($dataTable, self::SHOW_URL_ROUTE, self::EDIT_URL_ROUTE, self::REMOVE_URL_ROUTE, 'assets_maintenances_');

        return $dataTable;
    }


    /**
     * Get query source of dataTable.
     *
     *
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function query(Asset $model)
    {
        return $model->newQuery()
                     ->select([
                        'maintenances.*',
                        'assets.item',
                    ])
                    ->leftJoin('maintenances', 'maintenances.asset_id', '=', 'assets.id');
    }


    /**
     * Optional method if you want to use html builder.
     *
     * @return \Yajra\DataTables\Html\Builder
     */
    public function html()
    {
        return $this->builder()
            ->columns($this->getColumns())
            ->setTableId('AssetMaintenancesDatatable' . $this->tableSuffix)
            ->minifiedAjax(route($this->route, ['entityId' => $this->entityId]))

            ->setTableAttribute('class', 'table responsive table-hover')
            ->parameters([
                'dom' => "<'row'<'col-sm-12'tr>>\n\t\t\t<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7 dataTables_pager'lp>>",

                'stateSave' => true,
                'columnFilters' => [
                    [
                        'column_number' => 0,
                        'filter_type' => 'text'
                    ],
                    [
                        'column_number' => 1,
                        'filter_type' => 'bap_date_range_picker',

                    ],
                    [
                        'column_number' => 2,
                        'filter_type' => 'text'
                    ],
                ],
                'buttons' => DataTableHelper::buttons(),
                'regexp' => true

            ]);
    }

    /**
     * @return array
     */
    protected function getColumns()
    {

        return
            [
                'item' => [
                    'data' => 'item',
                    'name' => 'assets.item',
                    'title' => trans('maintenances::maintenances.table.item'),
                    'data_type' => 'text'
                ],
                'maintenance_date' => [
                    'data' => 'maintenance_date',
                    'title' => trans('maintenances::maintenances.table.maintenance_date'),
                    'data_type' => 'date'
                ],
                'value' => [
                    'data' => 'value',
                    'title' => trans('maintenances::maintenances.table.value'),
                    'data_type' => 'text'
                ],
                'actions' => ['title' => trans('core::core.table.actions'), 'data_type' => 'actions', 'orderable' => false],
            ];

    }
}
