<?php

namespace Modules\Assets\Database\Seeders;

use Faker\Factory;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Modules\Places\Entities\Place;
use Modules\Assets\Entities\Category;
use Illuminate\Database\Eloquent\Model;
use Modules\Companies\Entities\Company;
use Modules\Collaborators\Entities\Area;
use Modules\Suppliers\Entities\Supplier;
use Modules\Collaborators\Entities\Collaborator;

class AssetsSeederTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Factory::create();

        $itens = [ 'computador', 'impressora', 'carro', 'moto', 'mesa',
                   'cadeira', 'ar condicionado', 'televisão', 'notebook'];

        $conservationStates = [
            'Perfeito',
            'Bom',
            'Regular',
            'Ruim',
            'Muito ruim'
        ];

        $limit = 1000;

        for ($i = 0; $i < $limit; $i++) {

            $companies = Company::all()->pluck('id')->toArray();

            $company_id = $faker->randomElement($companies);
            $company = Company::find($company_id);
            $places = Place::where('company_id',$company_id)->pluck('id')->toArray();
            $areas = Area::where('company_id',$company_id)->pluck('id')->toArray();
            $categories = Category::where('company_id',$company_id)->pluck('id')->toArray();
            $status = $company->status()->pluck('status.id')->toArray();
            $collaborators = Collaborator::where('company_id',$company_id)->pluck('id')->toArray();
            $suppliers = Supplier::where('company_id',$company_id)->pluck('id')->toArray();

            DB::table('assets')->insert([ 
                'company_id' => $company_id,
                'place_id' => $faker->randomElement($places),
                'asset_number' => $faker->numberBetween(100000,9999999).'',
                'serial_number_1' => $faker->numberBetween(100000,9999999).'',
                'serial_number_2' => $faker->numberBetween(100000,9999999).'',
                'item' => $faker->randomElement($itens),
                'category_id' => $faker->randomElement($categories),
                'area_id' => $faker->randomElement($areas),
                'status_id' => $faker->randomElement($status),
                'model' => 'modelo...',
                'purchase_date' => $faker->dateTimeBetween('2000-01-01', '2018-10-01'),
                'purchase_value' => $faker->numberBetween(50,10000).',00',
                'conservation_state' => $faker->randomElement($conservationStates),
                'useful_life' => $faker->numberBetween(1,20),
                'responsible' => $faker->randomElement($collaborators),
                'supplier_id' => $faker->randomElement($suppliers),
            ]);
        }

    }
}
